/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.Comment;
import com.atlassian.jira.testkit.client.restclient.CommentsWithPaginationBean;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.util.Objects;
import javax.ws.rs.core.MediaType;

public class CommentClient
extends RestApiClient<CommentClient> {
    public CommentClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public Response<Comment> get(final String issueKey, final String commentID) throws UniformInterfaceException {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)CommentClient.this.commentWithID(issueKey, commentID).get(ClientResponse.class);
            }
        }, Comment.class);
    }

    public Response<Comment> get(final String issueKey, final String commentID, final String expand) throws UniformInterfaceException {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)CommentClient.this.commentWithID(issueKey, commentID).queryParam("expand", expand).get(ClientResponse.class);
            }
        }, Comment.class);
    }

    public Response<CommentsWithPaginationBean> getComments(final String issueKey) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)CommentClient.this.createResource().path("issue").path(issueKey).path("comment").get(ClientResponse.class);
            }
        }, CommentsWithPaginationBean.class);
    }

    public Response<CommentsWithPaginationBean> getComments(final String issueKey, final Integer startAt, final Integer maxResults, final String orderBy) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)CommentClient.this.createResource().path("issue").path(issueKey).path("comment").queryParam("startAt", Objects.toString(startAt)).queryParam("maxResults", Objects.toString(maxResults)).queryParam("orderBy", orderBy).get(ClientResponse.class);
            }
        }, CommentsWithPaginationBean.class);
    }

    public Response<CommentsWithPaginationBean> getComments(final String issueKey, final String expand) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)CommentClient.this.createResource().path("issue").path(issueKey).path("comment").queryParam("expand", expand).get(ClientResponse.class);
            }
        }, CommentsWithPaginationBean.class);
    }

    public Response<Comment> put(final String issueKey, final Comment comment) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)CommentClient.this.createResource().path("issue").path(issueKey).path("comment").path(comment.id).type(MediaType.APPLICATION_JSON_TYPE).put(ClientResponse.class, (Object)comment);
            }
        }, Comment.class);
    }

    public Response<Comment> put(final String issueKey, final Comment comment, final String expand) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)CommentClient.this.createResource().path("issue").path(issueKey).path("comment").path(comment.id).queryParam("expand", expand).type(MediaType.APPLICATION_JSON_TYPE).put(ClientResponse.class, (Object)comment);
            }
        }, Comment.class);
    }

    public Response<Comment> post(final String issueKey, final Comment comment) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)CommentClient.this.createResource().path("issue").path(issueKey).path("comment").type(MediaType.APPLICATION_JSON_TYPE).post(ClientResponse.class, (Object)comment);
            }
        }, Comment.class);
    }

    public Response<Comment> post(final String issueKey, final Comment comment, final String expand) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)CommentClient.this.createResource().path("issue").path(issueKey).path("comment").queryParam("expand", expand).type(MediaType.APPLICATION_JSON_TYPE).post(ClientResponse.class, (Object)comment);
            }
        }, Comment.class);
    }

    public Response delete(String issueKey, Comment comment) {
        return this.delete(issueKey, comment.id);
    }

    public Response delete(final String issueKey, final String commentId) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)CommentClient.this.createResource().path("issue").path(issueKey).path("comment").path(commentId).type(MediaType.APPLICATION_JSON_TYPE).delete(ClientResponse.class);
            }
        });
    }

    public Response getResponse(final String issueKey, final String commentID) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)CommentClient.this.commentWithID(issueKey, commentID).get(ClientResponse.class);
            }
        });
    }

    protected WebResource commentWithID(String issueKey, String commentID) {
        return this.createResource().path("issue").path(issueKey).path("comment").path(commentID);
    }
}

