/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.Filter;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang.StringUtils;

public class FilterClient
extends RestApiClient<FilterClient> {
    public FilterClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public Filter get(String filterId, Filter.Expand ... expand) throws UniformInterfaceException {
        return (Filter)this.filterWithId(filterId, expand).get(Filter.class);
    }

    public List<Filter> getFavouriteFilters(Filter.Expand ... expand) {
        return (List)this.addExpands(this.createResource().path("filter").path("favourite"), expand).get(Filter.FILTER_TYPE);
    }

    public Response getResponse(final String filterId) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)FilterClient.this.filterWithId(filterId, new Filter.Expand[0]).get(ClientResponse.class);
            }
        });
    }

    private WebResource filterResource() {
        return this.createResource().path("filter");
    }

    private WebResource addExpands(WebResource resource, Filter.Expand ... expand) {
        EnumSet expands = FilterClient.setOf(Filter.Expand.class, (Enum[])expand);
        if (expands.isEmpty()) {
            return resource;
        }
        return resource.queryParam("expand", FilterClient.percentEncode(StringUtils.join((Collection)expands, (String)",")));
    }

    protected WebResource filterWithId(String filterId, Filter.Expand ... expand) {
        return this.addExpands(this.createResource().path("filter").path(filterId), expand);
    }

    public Response<Filter> postFilterResponse(final Filter filter, final Filter.Expand ... expand) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)FilterClient.this.filterResourceForPost(expand).post(ClientResponse.class, (Object)filter);
            }
        }, Filter.class);
    }

    public Response<Filter> putFilterResponse(final Filter filter, final Filter.Expand ... expand) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)FilterClient.this.filterResourceForPut(filter.id, expand).put(ClientResponse.class, (Object)filter);
            }
        }, Filter.class);
    }

    public Response<List<Filter.FilterPermission>> getFilterPermissions(final String filterId) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)FilterClient.this.filterWithId(filterId, new Filter.Expand[0]).path("permission").get(ClientResponse.class);
            }
        }, new GenericType<List<Filter.FilterPermission>>(){});
    }

    public Response<Filter.FilterPermission> getFilterPermission(final String filterId, final String filterPermissionId) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)FilterClient.this.filterWithId(filterId, new Filter.Expand[0]).path("permission").path(filterPermissionId).get(ClientResponse.class);
            }
        }, Filter.FilterPermission.class);
    }

    public Response deleteFilterPermission(final String filterId, final String filterPermissionId) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)FilterClient.this.filterWithId(filterId, new Filter.Expand[0]).path("permission").path(filterPermissionId).delete(ClientResponse.class);
            }
        });
    }

    public Response<List<Filter.FilterPermission>> postFilterPermission(final String filterId, final FilterPermissionInputBean inputBean) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)FilterClient.this.filterWithId(filterId, new Filter.Expand[0]).path("permission").type(MediaType.APPLICATION_JSON_TYPE).post(ClientResponse.class, (Object)inputBean);
            }
        }, new GenericType<List<Filter.FilterPermission>>(){});
    }

    private WebResource.Builder filterResourceForPut(String filterId, Filter.Expand ... expand) {
        return this.addExpands(this.filterResource().path(filterId), expand).type(MediaType.APPLICATION_JSON_TYPE);
    }

    private WebResource.Builder filterResourceForPost(Filter.Expand ... expand) {
        return this.addExpands(this.filterResource(), expand).type(MediaType.APPLICATION_JSON_TYPE);
    }

    public Map<String, String> getDefaultShareScope() {
        return (Map)this.createResource().path("filter").path("defaultShareScope").get((GenericType)new GenericType<Map<String, String>>(){});
    }

    public Map<String, String> setDefaultShareScope(Map<String, String> scope) {
        return (Map)this.createResource().path("filter").path("defaultShareScope").type(MediaType.APPLICATION_JSON_TYPE).put((GenericType)new GenericType<Map<String, String>>(){}, scope);
    }

    public static class FilterPermissionInputBean {
        public String type;
        public String projectId;
        public String projectRoleId;
        public String groupname;
        public String userKey;
        public boolean view;
        public boolean edit;

        public FilterPermissionInputBean(String type, String projectId, String projectRoleId, String groupname) {
            this.type = type;
            this.projectId = projectId;
            this.projectRoleId = projectRoleId;
            this.groupname = groupname;
        }

        public FilterPermissionInputBean(String type, String projectId, String projectRoleId, String groupname, String userKey, boolean view, boolean edit) {
            this(type, projectId, projectRoleId, groupname);
            this.userKey = userKey;
            this.view = view;
            this.edit = edit;
        }
    }
}

