/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.PrioritySchemeBean;
import com.atlassian.jira.testkit.client.restclient.PrioritySchemeGetAllResponseBean;
import com.atlassian.jira.testkit.client.restclient.PrioritySchemeUpdateBean;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.google.common.collect.ImmutableMap;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.util.Objects;
import javax.ws.rs.core.MediaType;

public class PrioritySchemeClient
extends RestApiClient<PrioritySchemeClient> {
    public PrioritySchemeClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public Response<PrioritySchemeBean> createWithDefaultMapping(PrioritySchemeUpdateBean bean) {
        return this.toResponse(() -> (ClientResponse)((WebResource.Builder)this.resource().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).type(MediaType.APPLICATION_JSON_TYPE)).post(ClientResponse.class, (Object)bean), PrioritySchemeBean.class);
    }

    public Response<PrioritySchemeBean> updateWithDefaultMapping(PrioritySchemeUpdateBean bean, PrioritySchemeBean.Expand ... expand) {
        return this.toResponse(() -> (ClientResponse)((WebResource.Builder)this.schemeResource(bean.getId(), expand).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).type(MediaType.APPLICATION_JSON_TYPE)).put(ClientResponse.class, (Object)bean), PrioritySchemeBean.class);
    }

    public Response delete(long schemeId) {
        return this.toResponse(() -> (ClientResponse)this.schemeResource(schemeId, new PrioritySchemeBean.Expand[0]).delete(ClientResponse.class));
    }

    public Response<PrioritySchemeBean> get(long schemeId, PrioritySchemeBean.Expand ... expand) {
        return this.toResponse(() -> (ClientResponse)this.schemeResource(schemeId, expand).get(ClientResponse.class), PrioritySchemeBean.class);
    }

    public Response<PrioritySchemeGetAllResponseBean> getAll(Long startAt, Integer maxResults, PrioritySchemeGetAllResponseBean.Expand ... expand) {
        return this.toResponse(() -> {
            WebResource webResource = this.expandedResource(expand);
            if (Objects.nonNull(startAt)) {
                webResource = webResource.queryParam("startAt", startAt.toString());
            }
            if (Objects.nonNull(maxResults)) {
                webResource = webResource.queryParam("maxResults", maxResults.toString());
            }
            return (ClientResponse)webResource.get(ClientResponse.class);
        }, PrioritySchemeGetAllResponseBean.class);
    }

    public Response<PrioritySchemeBean> assign(long schemeId, String projectKey, PrioritySchemeBean.Expand ... expand) {
        return this.toResponse(() -> (ClientResponse)((WebResource.Builder)this.expanded(this.projectSchemeResource(projectKey), PrioritySchemeClient.setOf(PrioritySchemeBean.Expand.class, (Enum[])expand)).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).type(MediaType.APPLICATION_JSON_TYPE)).put(ClientResponse.class, (Object)ImmutableMap.of((Object)"id", (Object)schemeId)), PrioritySchemeBean.class);
    }

    public Response<PrioritySchemeBean> unassign(long schemeId, String projectKey, PrioritySchemeBean.Expand ... expand) {
        return this.toResponse(() -> (ClientResponse)this.expanded(this.projectSchemeResource(projectKey).path(Long.toString(schemeId)), PrioritySchemeClient.setOf(PrioritySchemeBean.Expand.class, (Enum[])expand)).delete(ClientResponse.class), PrioritySchemeBean.class);
    }

    public Response<PrioritySchemeBean> getForProject(String projectKey, PrioritySchemeBean.Expand ... expand) {
        return this.toResponse(() -> (ClientResponse)this.expanded(this.projectSchemeResource(projectKey), PrioritySchemeClient.setOf(PrioritySchemeBean.Expand.class, (Enum[])expand)).get(ClientResponse.class), PrioritySchemeBean.class);
    }

    private WebResource expandedResource(PrioritySchemeBean.Expand ... expand) {
        return this.expanded(this.resource(), PrioritySchemeClient.setOf(PrioritySchemeBean.Expand.class, (Enum[])expand));
    }

    private WebResource expandedResource(PrioritySchemeGetAllResponseBean.Expand ... expand) {
        return this.expanded(this.resource(), PrioritySchemeClient.setOf(PrioritySchemeGetAllResponseBean.Expand.class, (Enum[])expand));
    }

    private WebResource resource() {
        return this.createResource().path("priorityschemes");
    }

    private WebResource schemeResource(long schemeId, PrioritySchemeBean.Expand ... expand) {
        return this.expanded(this.resource().path(Long.toString(schemeId)), PrioritySchemeClient.setOf(PrioritySchemeBean.Expand.class, (Enum[])expand));
    }

    private WebResource projectSchemeResource(String projectKey) {
        return this.createResource().path("project").path(projectKey).path("priorityscheme");
    }
}

