/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.rest.api.util.StringList;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.atlassian.jira.testkit.client.restclient.SearchRequest;
import com.atlassian.jira.testkit.client.restclient.SearchResult;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import javax.ws.rs.core.MediaType;

public class SearchClient
extends RestApiClient<SearchClient> {
    public SearchClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public SearchResult getSearch(SearchRequest searchRequest) {
        return (SearchResult)this.searchResourceForGet(searchRequest).get(SearchResult.class);
    }

    public Response getSearchResponse(final SearchRequest searchRequest) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)SearchClient.this.searchResourceForGet(searchRequest).get(ClientResponse.class);
            }
        });
    }

    public SearchResult postSearch(SearchRequest searchRequest) {
        return (SearchResult)this.searchResourceForPost().post(SearchResult.class, (Object)searchRequest);
    }

    public Response<SearchResult> postSearchResponse(final SearchRequest searchRequest) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)SearchClient.this.searchResourceForPost().post(ClientResponse.class, (Object)searchRequest);
            }
        }, SearchResult.class);
    }

    private WebResource searchResource() {
        return this.createResource().path("search");
    }

    private WebResource.Builder searchResourceForPost() {
        return this.searchResource().type(MediaType.APPLICATION_JSON_TYPE);
    }

    private WebResource searchResourceForGet(SearchRequest searchRequest) {
        WebResource resource = this.searchResource();
        if (searchRequest.jql != null) {
            resource = resource.queryParam("jql", searchRequest.jql);
        }
        if (searchRequest.startAt != null) {
            resource = resource.queryParam("startAt", searchRequest.startAt.toString());
        }
        if (searchRequest.maxResults != null) {
            resource = resource.queryParam("maxResults", searchRequest.maxResults.toString());
        }
        if (searchRequest.validateQuery != null) {
            resource = resource.queryParam("validateQuery", searchRequest.validateQuery.toString());
        }
        if (searchRequest.fields != null) {
            resource = resource.queryParam("fields", StringList.fromList(searchRequest.fields).toQueryParam());
        }
        if (searchRequest.expand != null) {
            resource = resource.queryParam("expand", StringList.fromList(searchRequest.expand).toQueryParam());
        }
        return resource;
    }
}

