/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient.matcher;

import com.atlassian.jira.testkit.client.Backdoor;
import com.atlassian.jira.testkit.client.restclient.Project;
import com.atlassian.jira.testkit.client.restclient.ProjectClient;
import com.atlassian.jira.testkit.client.restclient.ProjectUpdateField;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class CorrectlyUpdatedProjectMatcher
extends TypeSafeMatcher<Project> {
    private String description = "";
    private final Map<ProjectUpdateField, String> expectedFields;
    private final Backdoor backdoor;

    public static Matcher<Project> create(ProjectClient.UpdateBean updateBean, Project originalProject, Backdoor backdoor) {
        HashMap expectedFields = Maps.newHashMap();
        for (ProjectUpdateField field : ProjectUpdateField.values()) {
            expectedFields.put(field, updateBean.getJson().get(field.jsonFieldName()) != null ? updateBean.getJson().get(field.jsonFieldName()) : field.getFrom(originalProject, backdoor));
        }
        return new CorrectlyUpdatedProjectMatcher(expectedFields, backdoor);
    }

    private CorrectlyUpdatedProjectMatcher(Map<ProjectUpdateField, String> expectedFields, Backdoor backdoor) {
        this.expectedFields = expectedFields;
        this.backdoor = backdoor;
    }

    protected boolean matchesSafely(Project project) {
        for (Map.Entry<ProjectUpdateField, String> entry : this.expectedFields.entrySet()) {
            String projectValue = entry.getKey().getFrom(project, this.backdoor);
            if (CorrectlyUpdatedProjectMatcher.nullSafeEquals(projectValue, entry.getValue())) continue;
            this.description = "Field '" + entry.getKey().jsonFieldName() + "' of project should be '" + entry.getValue() + "' but was '" + projectValue + "'";
            return false;
        }
        return true;
    }

    private static final boolean nullSafeEquals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public void describeTo(Description description) {
        description.appendText(this.description);
    }
}

