/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.rules;

import com.atlassian.jira.testkit.client.Backdoor;
import com.atlassian.jira.testkit.client.model.FeatureFlag;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.annotation.ParametersAreNonnullByDefault;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@ParametersAreNonnullByDefault
public class FeatureFlagUserRule
implements TestRule {
    private final Backdoor backdoor;
    private final String username;
    private final Collection<FeatureFlag> featureFlagsToEnable;
    private final Collection<FeatureFlag> featureFlagsToDisable;

    public FeatureFlagUserRule(Backdoor backdoor, String username, Collection<FeatureFlag> featureFlagsToEnable) {
        this(backdoor, username, featureFlagsToEnable, (Collection<FeatureFlag>)ImmutableList.of());
    }

    public FeatureFlagUserRule(Backdoor backdoor, String username, Collection<FeatureFlag> featureFlagsToEnable, Collection<FeatureFlag> featureFlagsToDisable) {
        this.backdoor = (Backdoor)Assertions.notNull((Object)backdoor);
        this.username = Assertions.notBlank((String)"username", (String)username);
        this.featureFlagsToEnable = ImmutableList.copyOf(featureFlagsToEnable);
        this.featureFlagsToDisable = ImmutableList.copyOf(featureFlagsToDisable);
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                FeatureFlagUserRule.this.featureFlagsToEnable.forEach(flag -> FeatureFlagUserRule.this.backdoor.darkFeatures().enableForUser(FeatureFlagUserRule.this.username, (FeatureFlag)flag));
                FeatureFlagUserRule.this.featureFlagsToEnable.forEach(flag -> FeatureFlagUserRule.this.backdoor.darkFeatures().disableForUser(FeatureFlagUserRule.this.username, (FeatureFlag)flag));
                try {
                    base.evaluate();
                }
                finally {
                    FeatureFlagUserRule.this.featureFlagsToEnable.forEach(flag -> FeatureFlagUserRule.this.backdoor.darkFeatures().resetForUser(FeatureFlagUserRule.this.username, (FeatureFlag)flag));
                    FeatureFlagUserRule.this.featureFlagsToDisable.forEach(flag -> FeatureFlagUserRule.this.backdoor.darkFeatures().resetForUser(FeatureFlagUserRule.this.username, (FeatureFlag)flag));
                }
            }
        };
    }
}

