/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.jira.testkit.client.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;

public class ApplicationPropertiesControl
extends BackdoorControl<ApplicationPropertiesControl> {
    public ApplicationPropertiesControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public ApplicationPropertiesControl setOption(String key, boolean value) {
        this.get(this.createResource().path("applicationProperties/option/set").queryParam("key", key).queryParam("value", "" + value));
        return this;
    }

    public ApplicationPropertiesControl setText(String key, String value) {
        this.createResource().path("applicationProperties/text/set").post(String.class, (Object)new KeyValueHolder(key, value));
        return this;
    }

    public ApplicationPropertiesControl setString(String key, String value) {
        this.createResource().path("applicationProperties/string/set").post(String.class, (Object)new KeyValueHolder(key, value));
        return this;
    }

    public boolean getOption(String key) {
        return Boolean.valueOf(this.get(this.createResource().path("applicationProperties/option/get").queryParam("key", key)));
    }

    public String getString(String key) {
        return this.get(this.createResource().path("applicationProperties/string/get").queryParam("key", key));
    }

    public ApplicationPropertiesControl disableXsrfChecking() {
        return this.setOption("jira.xsrf.enabled", false);
    }

    public ApplicationPropertiesControl enableXsrfChecking() {
        return this.setOption("jira.xsrf.enabled", true);
    }

    public String getJiraHome() {
        ConfigInfo info = (ConfigInfo)this.createResource().path("config-info").get(ConfigInfo.class);
        return info.jiraHomePath;
    }

    public static class ConfigInfo {
        public String jiraHomePath;
        public boolean isSetUp;

        public ConfigInfo() {
        }

        public ConfigInfo(String home, boolean isSetUp) {
            this.jiraHomePath = home;
            this.isSetUp = isSetUp;
        }
    }

    private static class KeyValueHolder {
        public String key;
        public String value;

        public KeyValueHolder(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

