/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.jira.testkit.client.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class MailServersControl
extends BackdoorControl<MailServersControl> {
    public static final String DEFAULT_FROM_ADDRESS = "jiratest@atlassian.com";
    public static final String DEFAULT_SUBJECT_PREFIX = "[JIRATEST]";

    public MailServersControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public void addSmtpServer(int port) {
        this.addSmtpServer(DEFAULT_FROM_ADDRESS, DEFAULT_SUBJECT_PREFIX, port);
    }

    public void addSmtpServer(String from, String prefix, int port) {
        this.addSmtpServer("Local Test Server", "", from, prefix, "localhost", port);
    }

    public void addSmtpServer(String name, String description, String from, String prefix, String serverName, int port) {
        this.addSmtpServer(name, description, from, prefix, serverName, port, false);
    }

    public void addSmtpServer(String name, String description, String from, String prefix, String serverName, int port, boolean tls) {
        this.addSmtpServer(name, description, from, prefix, serverName, port, null, null, tls);
    }

    public void addSmtpServer(String name, String description, String from, String prefix, String serverName, int port, String username, String password, boolean tls) {
        MailServersBean bean = new MailServersBean();
        bean.name = name;
        bean.description = description;
        bean.from = from;
        bean.prefix = prefix;
        bean.serverName = serverName;
        bean.port = String.valueOf(port);
        bean.tls = tls;
        bean.username = username;
        bean.password = password;
        this.createResource().path("mailServers/smtp").post(String.class, (Object)bean);
    }

    public void addPopServer(String name, int port) {
        this.addPopServer(name, "", "pop3", "localhost", port, "username", "password");
    }

    public void addImapServer(String name, int port) {
        this.addPopServer(name, "", "imap", "localhost", port, "username", "password");
    }

    public void addPopServer(String name, String description, String protocol, String serverName, int port, String username, String password) {
        MailServersBean bean = new MailServersBean();
        bean.name = name;
        bean.description = description;
        bean.protocol = protocol;
        bean.serverName = serverName;
        bean.port = String.valueOf(port);
        bean.username = username;
        bean.password = password;
        this.createResource().path("mailServers/pop").post(String.class, (Object)bean);
    }

    public void flushMailQueue() {
        WebResource webResourcePath = this.createResource().path("mailServers/flush");
        ClientResponse clientResponse = (ClientResponse)webResourcePath.get(ClientResponse.class);
        MatcherAssert.assertThat((String)"Clinet response status should be equal to \"OK\"", (Object)clientResponse.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.OK.getStatusCode()));
    }

    public boolean isSmtpConfigured() {
        return Boolean.parseBoolean((String)this.createResource().path("mailServers/smtpConfigured").get(String.class));
    }

    static class MailServersBean {
        public String name;
        public String description;
        public String protocol;
        public String serverName;
        public String port;
        public String username;
        public String password;
        public String from;
        public String prefix;
        public boolean tls;

        MailServersBean() {
        }
    }
}

