/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.jira.testkit.client.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.sun.jersey.api.client.WebResource;

public class PluginsControl
extends BackdoorControl<PluginsControl> {
    public PluginsControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public String getPluginState(String pluginKey) {
        WebResource resource = this.createResource().path("plugins/state").queryParam("key", pluginKey);
        return (String)resource.get(String.class);
    }

    public void disablePlugin(String pluginKey) {
        WebResource resource = this.createResource().path("plugins/disable").queryParam("key", pluginKey);
        this.get(resource);
    }

    public void enablePlugin(String pluginKey) {
        WebResource resource = this.createResource().path("plugins/enable").queryParam("key", pluginKey);
        this.get(resource);
    }

    public void disablePluginModule(String completeKey) {
        WebResource resource = this.createResource().path("plugins/disableModule").queryParam("key", completeKey);
        this.get(resource);
    }

    public void enablePluginModule(String completeKey) {
        WebResource resource = this.createResource().path("plugins/enableModule").queryParam("key", completeKey);
        this.get(resource);
    }

    public void setPluginLicense(String pluginKey, String license) throws JSONException {
        pluginKey = pluginKey + "-key";
        JSONObject licenseDetails = new JSONObject();
        licenseDetails.put("rawLicense", (Object)license);
        ((WebResource.Builder)this.createResourceForPath("plugins").path(pluginKey + "/license").accept(new String[]{"application/vnd.atl.plugins+json"}).type("application/vnd.atl.plugins+json")).put((Object)licenseDetails.toString());
    }

    public void setSettings(String key, String value) {
        this.createResource().path("plugins/settings").path(key).put((Object)value);
    }

    public String getSettings(String key) {
        return (String)this.createResource().path("plugins/settings").path(key).get(String.class);
    }

    public void clearSettings(String key) {
        this.createResource().path("plugins/settings").path(key).delete();
    }
}

