/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.testkit.beans.EntityList;
import com.atlassian.jira.testkit.beans.ProjectSchemesBean;
import com.atlassian.jira.testkit.client.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.sun.jersey.api.client.WebResource;

public class ProjectControl
extends BackdoorControl<ProjectControl> {
    public ProjectControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public long addProject(String name, String key, String lead) {
        return this.addProject(name, key, lead, "business");
    }

    public long addProject(String name, String key, String lead, String projectType) {
        String s = (String)this.createResource().path("project/add").queryParam("name", name).queryParam("key", key).queryParam("lead", lead).queryParam("type", projectType).get(String.class);
        return Long.parseLong(s);
    }

    public long addProjectWithTemplate(String name, String key, String lead, String projectTemplateKey) {
        String s = (String)this.createResource().path("project/add").queryParam("name", name).queryParam("key", key).queryParam("lead", lead).queryParam("template", projectTemplateKey).get(String.class);
        return Long.parseLong(s);
    }

    public void deleteProject(String key) {
        this.createResource().path("project").path(key).delete();
    }

    public void setPermissionScheme(long projectId, long schemeId) {
        this.get(this.createResource().path("project/permissionScheme/set").queryParam("project", "" + projectId).queryParam("scheme", "" + schemeId));
    }

    public void setNotificationScheme(long projectId, Long schemeId) {
        WebResource r = this.createResource().path("project/notificationScheme/set").queryParam("project", "" + projectId);
        if (schemeId != null) {
            r = r.queryParam("scheme", "" + schemeId);
        }
        this.get(r);
    }

    public void setIssueSecurityScheme(long projectId, Long schemeId) {
        WebResource r = this.createResource().path("project/issueSecurityScheme/set").queryParam("project", "" + projectId);
        if (schemeId != null) {
            r = r.queryParam("scheme", "" + schemeId);
        }
        this.get(r);
    }

    public void addFieldConfigurationScheme(long projectId, long schemeId) {
        this.get(this.createResource().path("project/fieldConfigurationScheme/add").queryParam("project", "" + projectId).queryParam("scheme", "" + schemeId));
    }

    public void removeFieldConfigurationScheme(long projectId, long schemeId) {
        this.get(this.createResource().path("project/fieldConfigurationScheme/remove").queryParam("project", "" + projectId).queryParam("scheme", "" + schemeId));
    }

    public void setProjectCategory(long projectId, long projectCategoryId) {
        this.get(this.createResource().path("project/projectCategory/set").queryParam("project", "" + projectId).queryParam("projectCategoryId", "" + projectCategoryId));
    }

    public void setIssueTypeScreenScheme(long projectId, long issueTypeScreenSchemeId) {
        this.get(this.createResource().path("project/issueTypeScreenScheme/set").queryParam("project", "" + projectId).queryParam("issueTypeScreenScheme", "" + issueTypeScreenSchemeId));
    }

    public void setDefaultIssueType(long projectId, String issueTypeId) {
        WebResource resource = this.createResource().path("project/defaultIssueType/set").queryParam("project", "" + projectId);
        if (issueTypeId != null) {
            resource = resource.queryParam("issueTypeId", "" + issueTypeId);
        }
        this.get(resource);
    }

    public void setProjectLead(long projectId, String username) {
        WebResource resource = this.createResource().path("project/projectLead/set").queryParam("project", "" + projectId).queryParam("username", "" + username);
        this.get(resource);
    }

    public void setProjectDefaultAssignee(long projectId, boolean setToProjectLead) {
        WebResource resource = this.createResource().path("project/defaultAssignee/set").queryParam("project", "" + projectId).queryParam("setToProjectLead", "" + setToProjectLead);
        this.get(resource);
    }

    public ProjectAssigneeType getProjectDefaultAssignee(String projectKey) {
        WebResource resource = this.createResource().path("project").path(projectKey).path("defaultAssignee");
        return ProjectAssigneeType.withId(Integer.parseInt(this.get(resource)));
    }

    public ProjectSchemesBean getSchemes(Long projectId) {
        return this.getSchemes(Long.toString(projectId));
    }

    public ProjectSchemesBean getSchemes(String projectIdOrKey) {
        return (ProjectSchemesBean)this.createProjectSchemesResource(projectIdOrKey).get(ProjectSchemesBean.class);
    }

    public ProjectTypeKey getProjectType(Long projectId) {
        String type = (String)this.createResource().path("project").path(String.valueOf(projectId)).path("type").get(String.class);
        return new ProjectTypeKey(type);
    }

    public void updateProjectType(Long projectId, ProjectTypeKey newProjectType) {
        this.createResource().path("project").path(String.valueOf(projectId)).path("type").path(newProjectType.getKey()).put();
    }

    private WebResource createProjectSchemesResource(String projectIdOrKey) {
        return this.createResource().path("project").path(projectIdOrKey).path("schemes");
    }

    public EntityList getEntityLinks(Long projectId) {
        return (EntityList)this.createResource().path("applinks").path("entitylinks").queryParam("projectId", Long.toString(projectId)).get(EntityList.class);
    }

    public static enum ProjectAssigneeType {
        PROJECT_DEFAULT(0),
        COMPONENT_LEAD(1),
        PROJECT_LEAD(2),
        UNASSIGNED(3);

        private final int id;

        private ProjectAssigneeType(int id) {
            this.id = id;
        }

        static ProjectAssigneeType withId(int id) {
            for (ProjectAssigneeType type : ProjectAssigneeType.values()) {
                if (type.id != id) continue;
                return type;
            }
            throw new IllegalArgumentException(id + " is not a valid ProjectAssigneeType id.");
        }
    }
}

