/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.rest.api.issue.IssueUpdateRequest;
import com.atlassian.jira.rest.api.issue.RemoteIssueLinkCreateOrUpdateRequest;
import com.atlassian.jira.rest.api.issue.RemoteIssueLinkCreateOrUpdateResponse;
import com.atlassian.jira.rest.api.util.StringList;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.Attachment;
import com.atlassian.jira.testkit.client.restclient.FieldMetaData;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueCreateMeta;
import com.atlassian.jira.testkit.client.restclient.IssueType;
import com.atlassian.jira.testkit.client.restclient.OperationalUpdateRequest;
import com.atlassian.jira.testkit.client.restclient.PageBean;
import com.atlassian.jira.testkit.client.restclient.RemoteIssueLink;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.atlassian.jira.testkit.client.restclient.User;
import com.atlassian.jira.util.collect.MapBuilder;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.multipart.BodyPart;
import com.sun.jersey.multipart.FormDataMultiPart;
import com.sun.jersey.multipart.file.FileDataBodyPart;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.core.MediaType;

public class IssueClient
extends RestApiClient<IssueClient> {
    public IssueClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public Issue get(String issueKey, Issue.Expand ... expand) throws UniformInterfaceException {
        return this.get(issueKey, false, expand);
    }

    public Issue get(String issueKey, boolean updateHistory, Issue.Expand ... expand) throws UniformInterfaceException {
        return (Issue)this.issueResource(issueKey, updateHistory, expand).get(Issue.class);
    }

    public Issue getWithProperties(String issueKey, List<String> properties, Issue.Expand ... expand) {
        return (Issue)this.issueResource(issueKey, false, expand).queryParam("properties", String.join((CharSequence)",", properties)).get(Issue.class);
    }

    public WebResource issueResource(String issueKey, Issue.Expand ... expand) {
        return this.issueWithKey(issueKey, Collections.emptyList(), IssueClient.setOf(Issue.Expand.class, (Enum[])expand), null);
    }

    public WebResource issueResource(String issueKey, boolean updateHistory, Issue.Expand ... expand) {
        return this.issueWithKey(issueKey, Collections.emptyList(), IssueClient.setOf(Issue.Expand.class, (Enum[])expand), updateHistory);
    }

    public Issue getPartially(String issueKey, StringList ... fields) throws UniformInterfaceException {
        return this.getPartially(issueKey, IssueClient.setOf(Issue.Expand.class, (Enum[])new Issue.Expand[0]), fields);
    }

    public Issue getPartially(String issueKey, EnumSet<Issue.Expand> expand, StringList ... fields) throws UniformInterfaceException {
        return (Issue)this.issueWithKey(issueKey, Arrays.asList(fields), expand, null).get(Issue.class);
    }

    public Issue getFromURL(String issueURL, Issue.Expand ... expand) throws UniformInterfaceException {
        EnumSet expands = IssueClient.setOf(Issue.Expand.class, (Enum[])expand);
        return (Issue)this.expanded(this.resourceRoot(issueURL), expands).get(Issue.class);
    }

    public IssueCreateResponse create(IssueUpdateRequest issue) {
        return this.create(issue, false);
    }

    public IssueCreateResponse create(IssueUpdateRequest issue, boolean updateHistory) {
        try {
            return (IssueCreateResponse)this.createResource().queryParam("updateHistory", Boolean.toString(updateHistory)).type(MediaType.APPLICATION_JSON_TYPE).post(IssueCreateResponse.class, (Object)issue);
        }
        catch (UniformInterfaceException e) {
            throw new RuntimeException("Failed to create issue: " + this.errorResponse(e.getResponse()), e);
        }
    }

    public void edit(String issueKey, IssueUpdateRequest updateRequest) {
        try {
            this.createResourceWithIssueKey(issueKey).type(MediaType.APPLICATION_JSON_TYPE).put((Object)updateRequest);
        }
        catch (UniformInterfaceException e) {
            throw new RuntimeException("Failed to edit issue: " + this.errorResponse(e.getResponse()), e);
        }
    }

    public Response getResponse(final IssueUpdateRequest issue) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)IssueClient.this.createResource().type(MediaType.APPLICATION_JSON_TYPE).post(ClientResponse.class, (Object)issue);
            }
        });
    }

    public Response operationalUpdateResponse(final String issueKey, final OperationalUpdateRequest update) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)IssueClient.this.createResource().path(issueKey).type(MediaType.APPLICATION_JSON_TYPE).put(ClientResponse.class, (Object)update);
            }
        });
    }

    public void operationalUpdate(String issueKey, OperationalUpdateRequest updateRequest) {
        try {
            this.createResource().path(issueKey).type(MediaType.APPLICATION_JSON_TYPE).put((Object)updateRequest);
        }
        catch (UniformInterfaceException e) {
            throw new RuntimeException("Failed to update issue: " + this.errorResponse(e.getResponse()), e);
        }
    }

    public void update(String issueKey, IssueUpdateRequest issue) {
        try {
            this.createResource().path(issueKey).type(MediaType.APPLICATION_JSON_TYPE).put((Object)issue);
        }
        catch (UniformInterfaceException e) {
            throw new RuntimeException("Failed to update issue: " + this.errorResponse(e.getResponse()), e);
        }
    }

    public Response updateResponse(final String issueKey, final IssueUpdateRequest update) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)IssueClient.this.createResource().path(issueKey).type(MediaType.APPLICATION_JSON_TYPE).put(ClientResponse.class, (Object)update);
            }
        });
    }

    public Response updateResponse(final String issueKey, final IssueUpdateRequest update, final boolean notifyUsers) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)IssueClient.this.createResource().path(issueKey).queryParam("notifyUsers", Boolean.toString(notifyUsers)).type(MediaType.APPLICATION_JSON_TYPE).put(ClientResponse.class, (Object)update);
            }
        });
    }

    public Response update(final String issueKey, final Map update) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)IssueClient.this.createResource().path(issueKey).type(MediaType.APPLICATION_JSON_TYPE).put(ClientResponse.class, (Object)update);
            }
        });
    }

    public Response delete(final String issueKey, final String deleteSubtasks) throws UniformInterfaceException {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                WebResource deleteResource = IssueClient.this.createResource().path(issueKey);
                if (deleteSubtasks != null) {
                    deleteResource = deleteResource.queryParam("deleteSubtasks", deleteSubtasks);
                }
                return (ClientResponse)deleteResource.delete(ClientResponse.class);
            }
        });
    }

    public Response assign(final String issueKey, final User assignee) throws UniformInterfaceException {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                WebResource assignResource = IssueClient.this.createResource().path(issueKey).path("assignee");
                return (ClientResponse)assignResource.type(MediaType.APPLICATION_JSON_TYPE).put(ClientResponse.class, (Object)assignee);
            }
        });
    }

    public Response transition(final String issueKey, final IssueUpdateRequest transition) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                WebResource transitionResource = IssueClient.this.createResource().path(issueKey).path("transitions");
                return (ClientResponse)transitionResource.type(MediaType.APPLICATION_JSON_TYPE).post(ClientResponse.class, (Object)transition);
            }
        });
    }

    public Response getResponse(final String issueKey) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)IssueClient.this.issueWithKey(issueKey, null, IssueClient.setOf((Class)Issue.Expand.class, (Enum[])new Issue.Expand[0]), null).get(ClientResponse.class);
            }
        });
    }

    protected WebResource issueWithKey(String issueKey, @Nullable List<StringList> fields, EnumSet<Issue.Expand> expand, Boolean updateHistory) {
        WebResource resource = this.createResource().path(issueKey);
        resource = this.addStringListsToQueryParams(resource, "fields", fields);
        if (updateHistory != null) {
            resource = resource.queryParam("updateHistory", Boolean.toString(updateHistory));
        }
        return this.expanded(resource, expand);
    }

    @Deprecated
    public IssueCreateMeta getCreateMeta(@Nullable List<StringList> projectIds, @Nullable List<StringList> projectKeys, @Nullable List<StringList> issueTypeIds, @Nullable List<String> issueTypeNames, IssueCreateMeta.Expand ... expand) {
        return (IssueCreateMeta)this.getCreateMetaResource(projectIds, projectKeys, issueTypeIds, issueTypeNames, IssueClient.setOf(IssueCreateMeta.Expand.class, (Enum[])expand)).get(IssueCreateMeta.class);
    }

    @Deprecated
    public Response getCreateMetaResponse(final @Nullable List<StringList> projectIds, final @Nullable List<StringList> projectKeys, final @Nullable List<StringList> issueTypeIds, final @Nullable List<String> issueTypeNames, final IssueCreateMeta.Expand ... expand) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)IssueClient.this.getCreateMetaResource(projectIds, projectKeys, issueTypeIds, issueTypeNames, IssueClient.setOf((Class)IssueCreateMeta.Expand.class, (Enum[])expand)).get(ClientResponse.class);
            }
        });
    }

    @Deprecated
    private WebResource getCreateMetaResource(@Nullable List<StringList> projectIds, @Nullable List<StringList> projectKeys, @Nullable List<StringList> issueTypeIds, @Nullable List<String> issueTypeNames, EnumSet<IssueCreateMeta.Expand> expand) {
        WebResource resource = this.createResource().path("createmeta");
        resource = this.addStringListsToQueryParams(resource, "projectIds", projectIds);
        resource = this.addStringListsToQueryParams(resource, "projectKeys", projectKeys);
        resource = this.addStringListsToQueryParams(resource, "issuetypeIds", issueTypeIds);
        resource = this.addStringsToQueryParams(resource, "issuetypeNames", issueTypeNames);
        resource = this.expanded(resource, expand);
        return resource;
    }

    public PageBean<IssueType> getCreateIssueMetaProjectIssueTypes(@Nonnull String projectIdOrKey, @Nullable Long startAt, @Nullable Integer maxResults) {
        return (PageBean)this.getCreateIssueMetaProjectIssueTypesResource(projectIdOrKey, startAt, maxResults).get((GenericType)new GenericType<PageBean<IssueType>>(){});
    }

    public WebResource getCreateIssueMetaProjectIssueTypesResource(@Nonnull String projectIdOrKey, @Nullable Long startAt, @Nullable Integer maxResults) {
        WebResource resource = this.createResource().path("createmeta").path(projectIdOrKey).path("issuetypes");
        resource = resource.queryParam("startAt", startAt == null ? null : startAt.toString());
        resource = resource.queryParam("maxResults", maxResults == null ? null : maxResults.toString());
        return resource;
    }

    public PageBean<IssueType> getCreateIssueMetaProjectIssueType(@Nonnull String projectIdOrKey, @Nonnull String issueTypeId, @Nullable Long startAt, @Nullable Integer maxResults) {
        return (PageBean)this.getCreateIssueMetaProjectIssueTypeResource(projectIdOrKey, issueTypeId, startAt, maxResults).get((GenericType)new GenericType<PageBean<IssueType>>(){});
    }

    public WebResource getCreateIssueMetaProjectIssueTypeResource(@Nonnull String projectIdOrKey, @Nonnull String issueTypeId, @Nullable Long startAt, @Nullable Integer maxResults) {
        WebResource resource = this.createResource().path("createmeta").path(projectIdOrKey).path("issuetypes").path(issueTypeId);
        resource = resource.queryParam("startAt", startAt == null ? null : startAt.toString());
        resource = resource.queryParam("maxResults", maxResults == null ? null : maxResults.toString());
        return resource;
    }

    public PageBean<FieldMetaData> getCreateIssueMetaFields(@Nonnull String projectIdOrKey, @Nonnull String issueTypeId, @Nullable Long startAt, @Nullable Integer maxResults) {
        return (PageBean)this.getCreateIssueMetaFieldsResource(projectIdOrKey, issueTypeId, startAt, maxResults).get((GenericType)new GenericType<PageBean<FieldMetaData>>(){});
    }

    private WebResource getCreateIssueMetaFieldsResource(@Nonnull String projectIdOrKey, @Nonnull String issueTypeId, @Nullable Long startAt, @Nullable Integer maxResults) {
        return this.getCreateIssueMetaProjectIssueTypesResource(projectIdOrKey, startAt, maxResults).path(issueTypeId);
    }

    public RemoteIssueLinkCreateOrUpdateResponse createOrUpdateRemoteIssueLink(String issueKey, RemoteIssueLinkCreateOrUpdateRequest remoteIssueLink) {
        try {
            return (RemoteIssueLinkCreateOrUpdateResponse)this.createResource().path(issueKey).path("remotelink").type(MediaType.APPLICATION_JSON_TYPE).post(RemoteIssueLinkCreateOrUpdateResponse.class, (Object)remoteIssueLink);
        }
        catch (UniformInterfaceException e) {
            throw new RuntimeException("Failed to create remote link: " + this.errorResponse(e.getResponse()), e);
        }
    }

    public Response createOrUpdateRemoteIssueLinkAndGetResponse(final String issueKey, final RemoteIssueLinkCreateOrUpdateRequest remoteIssueLink) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)IssueClient.this.createResource().path(issueKey).path("remotelink").type(MediaType.APPLICATION_JSON_TYPE).post(ClientResponse.class, (Object)remoteIssueLink);
            }
        });
    }

    public ClientResponse createOrUpdateRemoteIssueLinkAndGetClientResponse(String issueKey, RemoteIssueLinkCreateOrUpdateRequest remoteIssueLink) {
        return (ClientResponse)this.createResource().path(issueKey).path("remotelink").type(MediaType.APPLICATION_JSON_TYPE).post(ClientResponse.class, (Object)remoteIssueLink);
    }

    public Response updateRemoteIssueLink(final String issueKey, final String linkId, final RemoteIssueLinkCreateOrUpdateRequest remoteIssueLink) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)IssueClient.this.createResource().path(issueKey).path("remotelink").path(linkId).type(MediaType.APPLICATION_JSON_TYPE).put(ClientResponse.class, (Object)remoteIssueLink);
            }
        });
    }

    public Response deleteRemoteIssueLink(final String issueKey, final String remoteIssueLinkId) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)IssueClient.this.createResource().path(issueKey).path("remotelink").path(remoteIssueLinkId).type(MediaType.APPLICATION_JSON_TYPE).delete(ClientResponse.class);
            }
        });
    }

    public Response deleteRemoteIssueLinkByGlobalId(final String issueKey, final String globalId) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)IssueClient.this.createResource().path(issueKey).path("remotelink").queryParam("globalId", globalId).delete(ClientResponse.class);
            }
        });
    }

    public RemoteIssueLink getRemoteIssueLink(String issueKey, String remoteIssueLinkId) {
        return (RemoteIssueLink)this.getRemoteIssueLinkResource(issueKey, remoteIssueLinkId, null).get(RemoteIssueLink.class);
    }

    public List<RemoteIssueLink> getRemoteIssueLinks(String issueKey) {
        return (List)this.getRemoteIssueLinkResource(issueKey, null, null).get(RemoteIssueLink.REMOTE_ISSUE_LINKS_TYPE);
    }

    public RemoteIssueLink getRemoteIssueLinkByGlobalId(String issueKey, String globalId) {
        Map params = MapBuilder.newBuilder().add((Object)"globalId", (Object)globalId).toMap();
        return (RemoteIssueLink)this.getRemoteIssueLinkResource(issueKey, null, params).get(RemoteIssueLink.class);
    }

    public Response getRemoteIssueLinkResponse(final String issueKey, final String remoteIssueLinkId) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)IssueClient.this.getRemoteIssueLinkResource(issueKey, remoteIssueLinkId, null).get(ClientResponse.class);
            }
        });
    }

    public Response getRemoteIssueLinksResponse(String issueKey) {
        return this.getRemoteIssueLinksResponse(issueKey, null);
    }

    public Response getRemoteIssueLinksResponse(final String issueKey, final @Nullable Map<String, String> queryParams) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)IssueClient.this.getRemoteIssueLinkResource(issueKey, null, queryParams).get(ClientResponse.class);
            }
        });
    }

    public ClientResponse archive(String issueIdOrKey) {
        ClientResponse response = (ClientResponse)this.createResource().path(issueIdOrKey).path("archive").put(ClientResponse.class);
        response.close();
        return response;
    }

    public ClientResponse restore(String issueIdOrKey) {
        ClientResponse response = (ClientResponse)this.createResource().path(issueIdOrKey).path("restore").put(ClientResponse.class);
        response.close();
        return response;
    }

    public Response<List<Attachment>> attachFile(String issueIdOrKey, File file) {
        return this.toResponse(() -> {
            FormDataMultiPart multiPart = new FormDataMultiPart();
            multiPart.setMediaType(MediaType.MULTIPART_FORM_DATA_TYPE);
            multiPart.bodyPart((BodyPart)new FileDataBodyPart("file", file, MediaType.APPLICATION_OCTET_STREAM_TYPE));
            return (ClientResponse)((WebResource.Builder)this.createResource().path(issueIdOrKey).path("attachments").header("X-Atlassian-Token", (Object)"nocheck").type(multiPart.getMediaType())).post(ClientResponse.class, (Object)multiPart);
        }, new GenericType<List<Attachment>>(){});
    }

    private WebResource getRemoteIssueLinkResource(String issueKey, @Nullable String remoteIssueLinkId, @Nullable Map<String, String> queryParams) {
        WebResource resource = this.createResource().path(issueKey).path("remotelink");
        if (remoteIssueLinkId != null) {
            resource = resource.path(remoteIssueLinkId);
        }
        if (queryParams != null) {
            for (Map.Entry<String, String> entry : queryParams.entrySet()) {
                resource = resource.queryParam(entry.getKey(), entry.getValue());
            }
        }
        return resource;
    }

    private WebResource addStringListsToQueryParams(WebResource resource, String paramName, Iterable<StringList> stringLists) {
        if (stringLists != null) {
            for (StringList stringList : stringLists) {
                resource = resource.queryParam(paramName, stringList.toQueryParam());
            }
        }
        return resource;
    }

    private WebResource addStringsToQueryParams(WebResource resource, String paramName, Iterable<String> strings) {
        if (strings != null) {
            for (String string : strings) {
                resource = resource.queryParam(paramName, string);
            }
        }
        return resource;
    }

    private WebResource createResourceWithIssueKey(String issueKey) {
        return this.createResource().path(issueKey);
    }

    @Override
    protected WebResource createResource() {
        return super.createResource().path("issue");
    }
}

