/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.AddField;
import com.atlassian.jira.testkit.client.restclient.MoveField;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.atlassian.jira.testkit.client.restclient.Screen;
import com.atlassian.jira.testkit.client.restclient.ScreenField;
import com.atlassian.jira.testkit.client.restclient.ScreenTab;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.util.List;
import javax.ws.rs.core.MediaType;

public class ScreensClient
extends RestApiClient<ScreensClient> {
    private final Long id;

    public ScreensClient(JIRAEnvironmentData environmentData, Long id) {
        super(environmentData);
        this.id = id;
    }

    public List<ScreenTab> getAllTabs() {
        return this.getAllTabs(null);
    }

    public List<ScreenTab> getAllTabs(String projectKey) {
        return (List)this.getTabsResource(projectKey).get(ScreenTab.LIST);
    }

    public Response getAllTabsResponse() {
        return this.getAllTabsResponse(null);
    }

    public Response getAllTabsResponse(final String projectKey) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)ScreensClient.this.getTabsResource(projectKey).get(ClientResponse.class);
            }
        });
    }

    public ScreenTab createTab(String name) {
        ScreenTab screenTab = new ScreenTab();
        screenTab.name = name;
        return (ScreenTab)this.getTabsResource().type(MediaType.APPLICATION_JSON_TYPE).post(ScreenTab.class, (Object)screenTab);
    }

    public Response createTabWithResponse(String name) {
        final ScreenTab screenTab = new ScreenTab();
        screenTab.name = name;
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)ScreensClient.this.getTabsResource().type(MediaType.APPLICATION_JSON_TYPE).post(ClientResponse.class, (Object)screenTab);
            }
        });
    }

    public void deleteTab(Long id) {
        this.getTabsResource().path("" + id).type(MediaType.APPLICATION_JSON_TYPE).delete();
    }

    public Response deleteTabWithResponse(final Long id) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)ScreensClient.this.getTabsResource().path("" + id).type(MediaType.APPLICATION_JSON_TYPE).delete(ClientResponse.class);
            }
        });
    }

    public ScreenTab renameTab(Long id, String name) {
        ScreenTab screenTab = new ScreenTab();
        screenTab.name = name;
        return (ScreenTab)this.getTabsResource().path("" + id).type(MediaType.APPLICATION_JSON_TYPE).put(ScreenTab.class, (Object)screenTab);
    }

    public Response renameTabWithResponse(final Long id, final String name) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                ScreenTab screenTab = new ScreenTab();
                screenTab.name = name;
                return (ClientResponse)ScreensClient.this.getTabsResource().path("" + id).type(MediaType.APPLICATION_JSON_TYPE).put(ClientResponse.class, (Object)screenTab);
            }
        });
    }

    public void moveTab(Long id, Integer pos) {
        this.getTabsResource().path("" + id).path("move").path("" + pos).post();
    }

    public Response moveTabWithResponse(final Long id, final Integer pos) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)ScreensClient.this.getTabsResource().path("" + id).path("move").path("" + pos).post(ClientResponse.class);
            }
        });
    }

    public ScreenField addField(Long tab, String field) {
        AddField screenField = new AddField();
        screenField.fieldId = field;
        return (ScreenField)this.getTabsResource().path("" + tab).path("fields").type(MediaType.APPLICATION_JSON_TYPE).post(ScreenField.class, (Object)screenField);
    }

    public Response addFieldWithResponse(final Long tab, final String field) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                AddField screenField = new AddField();
                screenField.fieldId = field;
                return (ClientResponse)ScreensClient.this.getTabsResource().path("" + tab).path("fields").type(MediaType.APPLICATION_JSON_TYPE).post(ClientResponse.class, (Object)screenField);
            }
        });
    }

    public void moveField(Long tab, String fieldId, MoveField moveField) {
        this.getTabsResource().path("" + tab).path("fields").path(fieldId).path("move").type(MediaType.APPLICATION_JSON_TYPE).post((Object)moveField);
    }

    public Response moveFieldWithResponse(final Long tab, final String fieldId, final MoveField moveField) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)ScreensClient.this.getTabsResource().path("" + tab).path("fields").path(fieldId).path("move").type(MediaType.APPLICATION_JSON_TYPE).post(ClientResponse.class, (Object)moveField);
            }
        });
    }

    public void removeField(Long tab, String field) {
        this.getTabsResource().path("" + tab).path("fields").path(field).delete();
    }

    public Response removeFieldWithResponse(final Long tab, final String field) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)ScreensClient.this.getTabsResource().path("" + tab).path("fields").path(field).delete(ClientResponse.class);
            }
        });
    }

    public List<ScreenField> getAvailableFields() {
        return (List)this.screen().path("availableFields").get(ScreenField.LIST);
    }

    public Response getFieldsResponse(Long tab) {
        return this.getFieldsResponse(tab, null);
    }

    public Response getFieldsResponse(final Long tab, final String projectKey) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)ScreensClient.this.getTabsResource(projectKey).path("" + tab).path("fields").type(MediaType.APPLICATION_JSON_TYPE).get(ClientResponse.class);
            }
        });
    }

    public List<ScreenField> getFields(Long tab) {
        return this.getFields(tab, null);
    }

    public List<ScreenField> getFields(Long tab, String projectKey) {
        return (List)this.getTabsResource(projectKey).path("" + tab).path("fields").type(MediaType.APPLICATION_JSON_TYPE).get(ScreenField.LIST);
    }

    public Response getAllScreensResponse() {
        return this.toResponse(() -> (ClientResponse)this.createResource().path("screens").get(ClientResponse.class));
    }

    public List<Screen> getAllScreens() {
        return (List)((ClientResponse)this.createResource().path("screens").get(ClientResponse.class)).getEntity(Screen.LIST);
    }

    protected WebResource screen() {
        return this.createResource().path("screens").path("" + this.id);
    }

    private WebResource getTabsResource() {
        return this.getTabsResource(null);
    }

    private WebResource getTabsResource(String projectKey) {
        WebResource screenWebResource = this.screen();
        if (projectKey != null) {
            screenWebResource = screenWebResource.queryParam("projectKey", projectKey);
        }
        return screenWebResource.path("tabs");
    }
}

