/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.rest.api.issue.IssueUpdateRequest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.IssueTransitionsMeta;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import javax.ws.rs.core.MediaType;

public class TransitionsClient
extends RestApiClient<TransitionsClient> {
    public TransitionsClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public IssueTransitionsMeta get(String issueKey) throws UniformInterfaceException {
        return (IssueTransitionsMeta)this.transitionsForIssueWithKey(issueKey).get(IssueTransitionsMeta.class);
    }

    public Response postResponse(final String issueKey, final IssueUpdateRequest issueUpdateRequest) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)TransitionsClient.this.transitionsForIssueWithKey(issueKey).type(MediaType.APPLICATION_JSON_TYPE).post(ClientResponse.class, (Object)issueUpdateRequest);
            }
        });
    }

    private WebResource transitionsForIssueWithKey(String issueKey) {
        return this.createResource().path("issue").path(issueKey).path("transitions").queryParam("expand", "transitions.fields");
    }
}

