/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.xmlbackup;

import com.atlassian.jira.testkit.client.RestoreDataResources;
import com.atlassian.jira.util.collect.MapBuilder;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.commons.io.FileUtils;
import shaded.org.apache.commons.io.IOUtils;

public class XmlBackupCopier {
    private static final Logger log = LoggerFactory.getLogger(XmlBackupCopier.class);
    private static final String[] LOCALHOSTS = new String[]{"\"http://localhost:8080/jira\"", "\"http://localhost:8090/jira\"", "\"http://localhost:2990/jira\""};
    private final URL baseUrl;
    private Map<Pattern, String> baseUrlSubstitutions;

    public XmlBackupCopier(URL baseUrl) {
        this.baseUrl = (URL)Preconditions.checkNotNull((Object)baseUrl);
        this.baseUrlSubstitutions = this.createBaseUrlSubstitution(baseUrl.toString());
    }

    public boolean copyXmlBackupTo(String sourcePath, String destinationPath) {
        return this.copyXmlBackupTo(sourcePath, destinationPath, Collections.emptyMap());
    }

    public boolean copyXmlBackupTo(String sourcePath, String destinationPath, Map<Pattern, String> substitutions) {
        File destinationFile = new File(destinationPath);
        if (!destinationFile.getParentFile().exists() && !destinationFile.getParentFile().mkdirs()) {
            throw new RuntimeException("Tried to create parent folders of " + destinationPath + " which did not exist, but failed");
        }
        if (sourcePath.endsWith(".zip")) {
            try {
                log.trace("File '{}' is a ZIP file, copying without performing substiturions", (Object)sourcePath);
                FileUtils.copyFile(new File(sourcePath), destinationFile);
                return false;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            return this.performSubstitutions(new FileReader(sourcePath), destinationPath, substitutions);
        }
        catch (FileNotFoundException e) {
            log.trace("Error reading from '{}'", (Object)sourcePath);
            throw new RuntimeException("Could not read resource " + sourcePath, e);
        }
    }

    public boolean copyXmlBackupFromClassPathTo(String sourcePath, String destinationPath, Map<Pattern, String> substitutions) {
        File destinationFile = new File(destinationPath);
        if (!destinationFile.getParentFile().exists() && !destinationFile.getParentFile().mkdirs()) {
            throw new RuntimeException("Tried to create parent folders of " + destinationPath + " which did not exist, but failed");
        }
        InputStream inputStream = RestoreDataResources.getResourceAsStream(sourcePath);
        if (sourcePath.endsWith(".zip")) {
            try {
                log.trace("File '{}' is a ZIP file, copying without performing substiturions", (Object)sourcePath);
                FileUtils.copyInputStreamToFile(inputStream, destinationFile);
                return false;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            boolean e = this.performSubstitutions(new InputStreamReader(inputStream), destinationPath, substitutions);
            return e;
        }
        catch (NullPointerException e) {
            log.trace("Error reading from '{}'", (Object)sourcePath);
            throw new RuntimeException("Could not read resource " + sourcePath, e);
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
    }

    public boolean performSubstitutions(Reader sourceFile, String destinationPath, Map<Pattern, String> substitutions) {
        boolean bl;
        File destinationFile = new File(destinationPath);
        String ls = System.getProperty("line.separator");
        HashMap tokensPlusBaseUrlSubs = Maps.newHashMap(substitutions);
        tokensPlusBaseUrlSubs.putAll(this.baseUrlSubstitutions);
        boolean wasReplaced = false;
        BufferedReader reader = null;
        BufferedWriter writer = null;
        try {
            reader = new BufferedReader(sourceFile);
            writer = new BufferedWriter(new FileWriter(destinationFile));
            log.trace("Copying resource to '{}'", (Object)destinationPath);
            int lineNumber = 1;
            String line = reader.readLine();
            while (line != null) {
                for (Map.Entry subst : tokensPlusBaseUrlSubs.entrySet()) {
                    Matcher m = ((Pattern)subst.getKey()).matcher(line);
                    if (!m.find()) continue;
                    wasReplaced = true;
                    line = m.replaceAll((String)subst.getValue());
                    log.trace("Line {} replaced '{}' with '{}'", new Object[]{lineNumber, subst.getKey(), subst.getValue()});
                }
                writer.write(line);
                writer.write(ls);
                ++lineNumber;
                line = reader.readLine();
            }
            log.trace("Finished copying to '{}'", (Object)destinationPath);
            bl = wasReplaced;
        }
        catch (IOException e) {
            try {
                log.trace("Error copying to '{}'", (Object)destinationPath);
                throw new RuntimeException("Could not copy resource to the import directory in jira home " + destinationPath, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(reader);
        IOUtils.closeQuietly(writer);
        return bl;
    }

    protected Map<Pattern, String> createBaseUrlSubstitution(String baseURL) {
        MapBuilder builder = MapBuilder.newBuilder();
        for (String localhost : LOCALHOSTS) {
            builder.add((Object)Pattern.compile(String.format("value=%s", localhost), 16), (Object)Matcher.quoteReplacement(String.format("value=\"%s\"", baseURL)));
        }
        return builder.toMap();
    }
}

