/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.beans;

import com.atlassian.jira.testkit.beans.PermissionGrantBean;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class PermissionSchemeBean {
    @JsonProperty
    public Long id;
    @JsonProperty
    public URI self;
    @JsonProperty
    public String name;
    @JsonProperty
    public String description;
    @JsonProperty
    public List<PermissionGrantBean> permissions;

    public PermissionSchemeBean() {
    }

    public PermissionSchemeBean(Long id, String name) {
        this.name = name;
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public URI getSelf() {
        return this.self;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<PermissionGrantBean> getPermissions() {
        return this.permissions;
    }

    public PermissionSchemeBean setId(Long id) {
        this.id = id;
        return this;
    }

    public PermissionSchemeBean setName(String name) {
        this.name = name;
        return this;
    }

    public PermissionSchemeBean setDescription(String description) {
        this.description = description;
        return this;
    }

    public PermissionSchemeBean setPermissions(List<PermissionGrantBean> permissions) {
        this.permissions = permissions;
        return this;
    }

    public PermissionSchemeBean addPermissions(Collection<PermissionGrantBean> permissions) {
        this.initPermissions();
        this.permissions.addAll(permissions);
        return this;
    }

    public PermissionSchemeBean addPermission(PermissionGrantBean permission) {
        this.initPermissions();
        this.permissions.add(permission);
        return this;
    }

    private void initPermissions() {
        if (this.permissions == null) {
            this.permissions = Lists.newArrayList();
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("self", (Object)this.self).add("name", (Object)this.name).add("description", (Object)this.description).add("permissions", this.permissions).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PermissionSchemeBean that = (PermissionSchemeBean)o;
        return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.description, (Object)that.description) && Objects.equal(this.permissions, that.permissions);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.description, this.permissions});
    }
}

