/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.AbstractAmpsMojo;
import com.atlassian.maven.plugins.amps.product.ProductHandlerFactory;
import com.atlassian.maven.plugins.amps.util.GoogleAmpsTracker;
import java.util.prefs.Preferences;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractProductAwareMojo
extends AbstractAmpsMojo {
    private static final String PREF_FIRSTRUN_PREFIX = "sdk-firstrun";
    @Parameter(property="product")
    private String product;
    @Parameter(property="instanceId")
    protected String instanceId;
    @Parameter(property="allow.google.tracking", defaultValue="true")
    protected boolean allowGoogleTracking;
    private GoogleAmpsTracker googleTracker;

    protected String getDefaultProductId() throws MojoExecutionException {
        String nameOfTheCurrentMavenPlugin = this.getPluginInformation().getId();
        if (ProductHandlerFactory.getIds().contains(nameOfTheCurrentMavenPlugin)) {
            return nameOfTheCurrentMavenPlugin;
        }
        return null;
    }

    protected final String getProductId() throws MojoExecutionException {
        if (this.product == null) {
            this.product = this.getDefaultProductId();
            if (this.product == null) {
                this.product = "refapp";
            }
        }
        return this.product;
    }

    protected GoogleAmpsTracker getGoogleTracker() throws MojoExecutionException {
        if (null == this.googleTracker && this.googleTrackingAllowed()) {
            this.googleTracker = new GoogleAmpsTracker(this.getProductId(), this.getAmpsPluginVersion(), this.getPluginInformation().getVersion(), this.getLog());
            if (this.googleTrackingAllowed()) {
                this.getLog().info((CharSequence)"Google Analytics Tracking is enabled to collect AMPS usage statistics.");
                this.getLog().info((CharSequence)"Although no personal information is sent, you may disable tracking by adding <allowGoogleTracking>false</allowGoogleTracking> to the amps plugin configuration in your pom.xml");
            }
            this.googleTracker.setEnabled(this.googleTrackingAllowed());
        } else {
            this.googleTracker = new GoogleAmpsTracker();
        }
        return this.googleTracker;
    }

    protected boolean googleTrackingAllowed() {
        return this.allowGoogleTracking;
    }

    protected void trackFirstRunIfNeeded() throws MojoExecutionException {
        boolean runningShellScript;
        boolean bl = runningShellScript = null != System.getenv("ATLAS_VERSION");
        if (this.googleTrackingAllowed() && runningShellScript) {
            String firstRunKey = "sdk-firstrun-" + this.getAmpsPluginVersion();
            Preferences prefs = Preferences.userNodeForPackage(((Object)((Object)this)).getClass());
            String alreadyRan = prefs.get(firstRunKey, null);
            if (null == alreadyRan) {
                this.getGoogleTracker().track("SDK First Run", this.getAmpsPluginVersion());
                prefs.put(firstRunKey, "true");
            }
        }
    }
}

