/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.AbstractTestGroupsHandlerMojo;
import com.atlassian.maven.plugins.amps.DataSource;
import com.atlassian.maven.plugins.amps.LibArtifact;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.ProductExecution;
import com.atlassian.maven.plugins.amps.product.ImportMethod;
import com.atlassian.maven.plugins.amps.product.jira.JiraDatabase;
import com.atlassian.maven.plugins.amps.product.jira.JiraDatabaseFactory;
import com.atlassian.maven.plugins.amps.product.jira.JiraDatabaseType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="prepare-database", requiresDependencyResolution=ResolutionScope.TEST)
public class PrepareDatabaseMojo
extends AbstractTestGroupsHandlerMojo {
    @Parameter(property="maven.test.skip", defaultValue="false")
    private boolean testsSkip;
    @Parameter(property="skipTests", defaultValue="false")
    private boolean skipTests;
    @Parameter(property="db.dump.file.path")
    private String dumpFilePath;
    @Parameter(property="import.method")
    private String importMethod;
    @Parameter(property="db.default.database")
    private String defaultDatabase;
    @Parameter(property="db.system.username")
    private String systemUsername;
    @Parameter(property="db.system.password")
    private String systemPassword;

    @Override
    protected void doExecute() throws MojoExecutionException {
        if (this.testsSkip || this.skipTests) {
            this.getLog().info((CharSequence)"Pre integration tests skipped");
            return;
        }
        for (ProductExecution jira : this.getJiraExecutions()) {
            DataSource dataSource = this.getOnlyDataSource(jira);
            if (dataSource == null) continue;
            this.prepareDatabase(jira, dataSource);
        }
    }

    private Collection<ProductExecution> getJiraExecutions() throws MojoExecutionException {
        return this.getProductExecutions().stream().filter(execution -> "jira".equals(execution.getProduct().getId())).collect(Collectors.toList());
    }

    @Nullable
    private DataSource getOnlyDataSource(ProductExecution jiraExecution) {
        List<DataSource> dataSources = jiraExecution.getProduct().getDataSources();
        switch (dataSources.size()) {
            case 0: {
                this.getLog().info((CharSequence)"No dataSource configured for pre-integration-test");
                return null;
            }
            case 1: {
                return dataSources.get(0);
            }
        }
        this.getLog().info((CharSequence)("Multiple dataSources not supported. Configuration has these " + dataSources.size() + " dataSources:"));
        for (DataSource dataSource : dataSources) {
            this.getLog().info((CharSequence)("- Database URL: " + dataSource.getUrl()));
        }
        return null;
    }

    private void prepareDatabase(ProductExecution jiraExecution, DataSource dataSource) throws MojoExecutionException {
        JiraDatabaseType databaseType = JiraDatabaseType.getDatabaseType(dataSource).orElseThrow(() -> new MojoExecutionException("Could not detect database type for dataSource: " + dataSource));
        dataSource.getLibArtifacts().addAll(this.getJdbcDriverArtifacts(jiraExecution, databaseType));
        this.populateParameters(dataSource);
        JiraDatabase jiraDatabase = new JiraDatabaseFactory(this.getLog()).getJiraDatabase(dataSource).orElseThrow(() -> new MojoExecutionException("Cannot get database for " + dataSource));
        this.dropAndCreate(jiraDatabase);
        this.importDumpFile(jiraDatabase);
    }

    private Collection<LibArtifact> getJdbcDriverArtifacts(ProductExecution jiraExecution, JiraDatabaseType databaseType) throws MojoExecutionException {
        List<ProductArtifact> libArtifacts = jiraExecution.getProduct().getLibArtifacts();
        if (libArtifacts == null || libArtifacts.isEmpty()) {
            throw new MojoExecutionException("Product library artifact is empty, please provide library for database: " + (Object)((Object)databaseType));
        }
        return libArtifacts.stream().map(this::toLibArtifact).collect(Collectors.toList());
    }

    private LibArtifact toLibArtifact(ProductArtifact productArtifact) {
        return new LibArtifact(productArtifact.getGroupId(), productArtifact.getArtifactId(), productArtifact.getVersion());
    }

    private void populateParameters(DataSource dataSource) {
        if (StringUtils.isNotEmpty((CharSequence)this.defaultDatabase)) {
            dataSource.setDefaultDatabase(this.defaultDatabase);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.systemUsername)) {
            dataSource.setSystemUsername(this.systemUsername);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.systemPassword)) {
            dataSource.setSystemPassword(this.systemPassword);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.dumpFilePath)) {
            dataSource.setDumpFilePath(this.dumpFilePath);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.importMethod)) {
            dataSource.setImportMethod(this.importMethod);
        } else {
            dataSource.setImportMethod(ImportMethod.SQL.getMethod());
        }
        this.getLog().info((CharSequence)("Pre-integration-test import method: " + dataSource.getImportMethod()));
    }

    private void dropAndCreate(JiraDatabase jiraDatabase) throws MojoExecutionException {
        this.mojoExecutorWrapper.executeWithMergedConfig(this.getSqlMavenPlugin(jiraDatabase), MojoExecutor.goal("execute"), jiraDatabase.getSqlMavenCreateConfiguration(), this.getMavenContext().getExecutionEnvironment());
    }

    private Plugin getSqlMavenPlugin(JiraDatabase jiraDatabase) {
        Plugin sqlMavenPlugin = this.getMavenContext().getPlugin("org.codehaus.mojo", "sql-maven-plugin");
        ArrayList<Dependency> pluginDependencies = new ArrayList<Dependency>(sqlMavenPlugin.getDependencies());
        pluginDependencies.addAll(jiraDatabase.getSqlMavenDependencies());
        sqlMavenPlugin.setDependencies(pluginDependencies);
        return sqlMavenPlugin;
    }

    private void importDumpFile(JiraDatabase jiraDatabase) throws MojoExecutionException {
        DataSource dataSource = jiraDatabase.getDataSource();
        String dumpFileName = dataSource.getDumpFilePath();
        if (StringUtils.isNotEmpty((CharSequence)dumpFileName)) {
            File dumpFile = new File(dumpFileName);
            if (!dumpFile.isFile()) {
                throw new MojoExecutionException(String.format("Import file '%s' is not a file", dumpFileName));
            }
            this.getLog().info((CharSequence)("Importing dump file: " + dumpFileName));
            if (ImportMethod.SQL == ImportMethod.getValueOf(dataSource.getImportMethod())) {
                this.importSqlDumpFile(jiraDatabase);
            } else {
                this.importDataUsingDatabaseSpecificTool(jiraDatabase);
            }
        }
    }

    private void importSqlDumpFile(JiraDatabase jiraDatabase) throws MojoExecutionException {
        this.mojoExecutorWrapper.executeWithMergedConfig(this.getSqlMavenPlugin(jiraDatabase), MojoExecutor.goal("execute"), jiraDatabase.getSqlMavenFileImportConfiguration(), this.getMavenContext().getExecutionEnvironment());
    }

    private void importDataUsingDatabaseSpecificTool(JiraDatabase jiraDatabase) throws MojoExecutionException {
        Xpp3Dom importConfiguration = jiraDatabase.getExecMavenToolImportConfiguration();
        if (importConfiguration == null) {
            this.getLog().warn((CharSequence)String.format("No configuration provided for %s - skipping import", jiraDatabase));
        } else {
            this.mojoExecutorWrapper.executeWithMergedConfig(this.getMavenContext().getPlugin("org.codehaus.mojo", "exec-maven-plugin"), MojoExecutor.goal("exec"), importConfiguration, this.getMavenContext().getExecutionEnvironment());
        }
    }
}

