package com.atlassian.maven.plugins.jira;

import com.atlassian.maven.plugins.amps.IntegrationTestMojo;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.product.ProductHandlerFactory;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;

import java.util.HashMap;
import java.util.Map;

@Mojo(name = "integration-test", requiresDependencyResolution = ResolutionScope.TEST)
public class JiraIntegrationTestMojo extends IntegrationTestMojo
{
    @Override
    protected String getDefaultProductId() {
        return ProductHandlerFactory.JIRA;
    }

    @Override
    protected Map<String, String> getProductFunctionalTestProperties(final Product product) {
        final Map<String, String> props = new HashMap<>();

        // set up properties for Jira functional test library
        props.put("jira.protocol", product.getProtocol());
        props.put("jira.host", product.getServer());
        props.put("jira.port", Integer.toString(product.getWebPort()));
        props.put("jira.xml.data.location", getMavenContext().getProject().getBasedir() + "/src/test/xml");
        props.put("jira.context", product.getContextPath());

        getLog().info("jira props: " + props);

        return props;
    }
}
