/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.client.api.storage.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public enum GrantType {
    AUTHORIZATION_CODE_GRANT("authorization_code", true),
    CLIENT_CREDENTIALS_GRANT("client_credentials", false);

    public static final Set<GrantType> CLIENT_DEFAULT_GRANT_TYPES;
    private static final Set<GrantType> CLIENT_CREDENTIALS_GRANT_ONLY;
    private final String name;
    private final boolean requiresAuthorization;

    private GrantType(String name, boolean requiresAuthorization) {
        this.name = name;
        this.requiresAuthorization = requiresAuthorization;
    }

    @JsonCreator
    public static GrantType forValue(String value) {
        return GrantType.getByName(value).orElse(null);
    }

    public static GrantType defaultGrantType() {
        return AUTHORIZATION_CODE_GRANT;
    }

    public static Optional<GrantType> getByName(String name) {
        return Arrays.stream(GrantType.values()).filter(type -> type.name.equalsIgnoreCase(name)).findAny();
    }

    public static GrantType getByNameOrDefault(String name) {
        return GrantType.getByName(name).orElse(GrantType.defaultGrantType());
    }

    public static GrantType orDefaultGrantType(GrantType grantType) {
        return Optional.ofNullable(grantType).orElse(GrantType.defaultGrantType());
    }

    public static boolean isClientCredentialsOnly(Set<GrantType> supportedGrantTypes) {
        return Objects.equals(supportedGrantTypes, CLIENT_CREDENTIALS_GRANT_ONLY);
    }

    @JsonValue
    public String getName() {
        return this.name;
    }

    public boolean requiresAuthorization() {
        return this.requiresAuthorization;
    }

    static {
        CLIENT_DEFAULT_GRANT_TYPES = Set.of(AUTHORIZATION_CODE_GRANT, CLIENT_CREDENTIALS_GRANT);
        CLIENT_CREDENTIALS_GRANT_ONLY = Collections.singleton(CLIENT_CREDENTIALS_GRANT);
    }
}

