/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.impl.config;

import com.atlassian.json.marshal.Jsonable;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.servlet.ContentTypeResolver;
import com.atlassian.plugin.servlet.ServletContextFactory;
import com.atlassian.plugin.util.validation.ValidationException;
import com.atlassian.plugin.webresource.Flags;
import com.atlassian.plugin.webresource.PluginResourceContainer;
import com.atlassian.plugin.webresource.ResourceBatchingConfiguration;
import com.atlassian.plugin.webresource.ResourceUtils;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import com.atlassian.plugin.webresource.WebResourceTransformation;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.plugin.webresource.cdn.CdnResourceUrlTransformer;
import com.atlassian.plugin.webresource.cdn.CdnResourceUrlTransformerImpl;
import com.atlassian.plugin.webresource.cdn.mapper.DefaultWebResourceMapper;
import com.atlassian.plugin.webresource.cdn.mapper.MappingParser;
import com.atlassian.plugin.webresource.cdn.mapper.NoOpWebResourceMapper;
import com.atlassian.plugin.webresource.cdn.mapper.WebResourceMapper;
import com.atlassian.plugin.webresource.condition.DecoratingCondition;
import com.atlassian.plugin.webresource.impl.CachedCondition;
import com.atlassian.plugin.webresource.impl.CachedTransformers;
import com.atlassian.plugin.webresource.impl.RequestCache;
import com.atlassian.plugin.webresource.impl.annotators.AsyncLoaderAnnotator;
import com.atlassian.plugin.webresource.impl.annotators.ListOfAnnotators;
import com.atlassian.plugin.webresource.impl.annotators.LocationContentAnnotator;
import com.atlassian.plugin.webresource.impl.annotators.ModuleAnnotator;
import com.atlassian.plugin.webresource.impl.annotators.ResourceContentAnnotator;
import com.atlassian.plugin.webresource.impl.annotators.SemicolonResourceContentAnnotator;
import com.atlassian.plugin.webresource.impl.annotators.TryCatchJsResourceContentAnnotator;
import com.atlassian.plugin.webresource.impl.modules.ModulesDescriptor;
import com.atlassian.plugin.webresource.impl.snapshot.Bundle;
import com.atlassian.plugin.webresource.impl.snapshot.Context;
import com.atlassian.plugin.webresource.impl.snapshot.Deprecation;
import com.atlassian.plugin.webresource.impl.snapshot.ModuleResource;
import com.atlassian.plugin.webresource.impl.snapshot.Resource;
import com.atlassian.plugin.webresource.impl.snapshot.RootPage;
import com.atlassian.plugin.webresource.impl.snapshot.Snapshot;
import com.atlassian.plugin.webresource.impl.snapshot.WebModule;
import com.atlassian.plugin.webresource.impl.snapshot.WebResource;
import com.atlassian.plugin.webresource.impl.support.ConditionInstanceCache;
import com.atlassian.plugin.webresource.impl.support.Support;
import com.atlassian.plugin.webresource.impl.support.Tuple;
import com.atlassian.plugin.webresource.impl.support.http.BaseRouter;
import com.atlassian.plugin.webresource.prebake.PrebakeConfig;
import com.atlassian.plugin.webresource.transformer.StaticTransformers;
import com.atlassian.plugin.webresource.transformer.TransformerCache;
import com.atlassian.plugin.webresource.transformer.TransformerParameters;
import com.atlassian.plugin.webresource.util.HashBuilder;
import com.atlassian.plugin.webresource.util.TimeSpan;
import com.atlassian.sourcemap.Util;
import com.atlassian.webresource.api.assembler.resource.CompleteWebResourceKey;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import com.atlassian.webresource.spi.CompilerEntry;
import com.atlassian.webresource.spi.CompilerUtil;
import com.atlassian.webresource.spi.NoOpResourceCompiler;
import com.atlassian.webresource.spi.ResourceCompiler;
import com.atlassian.webresource.spi.TransformationDto;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.io.CharStreams;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    public static final String IEONLY_PARAM_NAME = "ieonly";
    public static final String SOURCE_PARAM_NAME = "source";
    public static final String BATCH_PARAM_NAME = "batch";
    public static final String MEDIA_PARAM_NAME = "media";
    public static final String CONTENT_TYPE_PARAM_NAME = "content-type";
    public static final String CACHE_PARAM_NAME = "cache";
    public static final String ALLOW_PUBLIC_USE_PARAM_NAME = "allow-public-use";
    public static final String CONDITIONAL_COMMENT_PARAM_NAME = "conditionalComment";
    public static final String ASYNC_SCRIPT_PARAM_NAME = "async";
    public static final String INITIAL_RENDERED_SCRIPT_PARAM_NAME = "data-initially-rendered";
    public static final String WRM_KEY_PARAM_NAME = "data-wrm-key";
    public static final String WRM_BATCH_TYPE_PARAM_NAME = "data-wrm-batch-type";
    public static final String DOWNLOAD_PARAM_VALUE = "download";
    public static final String JS_TYPE = "js";
    public static final String JS_CONTENT_TYPE = "application/javascript";
    public static final String CSS_TYPE = "css";
    public static final String CSS_CONTENT_TYPE = "text/css";
    public static final String SOY_TYPE = "soy";
    public static final String CSS_EXTENSION = ".css";
    public static final String LESS_EXTENSION = ".less";
    public static final String JS_EXTENSION = ".js";
    public static final String SOY_EXTENSION = ".soy";
    public static final String[] BATCH_TYPES = new String[]{"css", "js"};
    public static final String WEB_RESOURCE_MODULE_LOADER = "wr";
    private static final int ATLASSIAN_MODULES_VERSION = 2;
    public static final int GET_URL_MAX_LENGTH = 8192;
    public static final String[] HTTP_PARAM_NAMES = new String[]{"ieonly", "media", "content-type", "cache", "conditionalComment", "allow-public-use"};
    public static final List<String> PARAMS_SORT_ORDER = Arrays.asList("cache", "media", "conditionalComment", "ieonly");
    public static final String ATLASSIAN_MODULES_XML = "atlassian-modules.xml";
    public static final String CONTEXT_PREFIX = "_context";
    public static final String SUPER_BATCH_CONTEXT_KEY = "_super";
    public static final String SUPERBATCH_KEY = "_context:_super";
    public static final String SYNCBATCH_CONTEXT_KEY = "_sync";
    public static final String SYNCBATCH_KEY = "_context:_sync";
    private static final String DISABLE_MINIFICATION = "atlassian.webresource.disable.minification";
    private static final String DISABLE_URL_CACHING = "atlassian.webresource.disable.url.caching";
    private static final String GLOBAL_MINIFICATION_ENABLED = "atlassian.webresource.enable.global.minification";
    private static final String PREBAKE_FEATURE_ENABLED = "atlassian.webresource.enable.prebake";
    private static final String CT_CDN_BASE_URL = "atlassian.webresource.ct.cdn.base.url";
    private static final String PREBAKE_CSS_RESOURCES = "atlassian.webresource.enable.css.prebake";
    private static final String IGNORE_PREBAKE_WARNINGS = "atlassian.webresource.ignore.prebake.warnings";
    private static final String STATIC_CONTEXT_ORDER_ENABLED = "atlassian.webresource.stable.contexts.enable";
    private static final String COMPILED_RESOURCE_LOCATION_PARAMETER = "compiledLocation";
    private static final String PLUGIN_KEY = "com.atlassian.plugins.atlassian-plugins-webresource-plugin";
    public static final String IN_ORDER_LOADER_RESOURCE_KEY = "com.atlassian.plugins.atlassian-plugins-webresource-plugin:in-order-loader";
    private static final List<String> BEFORE_ALL_AMD_RESOURCES = Collections.singletonList("com.atlassian.plugins.atlassian-plugins-webresource-plugin:atlassian-module");
    private static final Pattern SNAPSHOT_PLUGIN_REGEX = Pattern.compile("SNAPSHOT", 2);
    private static final Logger log = LoggerFactory.getLogger(Config.class);
    private Logger supportLogger = Support.LOGGER;
    private final WebResourceIntegration integration;
    private final ResourceBatchingConfiguration batchingConfiguration;
    private final WebResourceUrlProvider urlProvider;
    private final boolean isContentCacheEnabled;
    private final int contentCacheSize;
    private final Integer incrementalCacheSize;
    private final boolean usePluginInstallTimeInsteadOfTheVersionForSnapshotPlugins;
    private ContentTypeResolver contentTypeResolver;
    private final ServletContextFactory servletContextFactory;
    private StaticTransformers staticTransformers;
    private final TransformerCache transformerCache;
    private final ResettableLazyReference<WebResourceMapper> cdnUrlMapper = new ResettableLazyReference<WebResourceMapper>(){

        protected WebResourceMapper create() throws Exception {
            if (Config.this.integration.isCtCdnMappingEnabled()) {
                Optional prebakeConfig;
                Optional<Object> optional = prebakeConfig = Config.this.integration.getCDNStrategy() != null ? Config.this.integration.getCDNStrategy().getPrebakeConfig() : Optional.empty();
                if (prebakeConfig.isPresent()) {
                    try {
                        log.info("Creating DefaultWebResourceMapper");
                        return new DefaultWebResourceMapper(Config.this.integration, new MappingParser(), (PrebakeConfig)prebakeConfig.get(), Config.this.computeGlobalStateHash(), Config.this.getCtCdnBaseUrl(), Config.this.integration.getBaseUrl(UrlMode.RELATIVE));
                    }
                    catch (FileNotFoundException e) {
                        return new NoOpWebResourceMapper(e);
                    }
                    catch (Exception e) {
                        log.info("DefaultWebResourceMapper was not created properly. Pre-baked CT-CDN is disabled but will fall back to product's CDN Strategy, if any.", (Throwable)e);
                        return new NoOpWebResourceMapper(e);
                    }
                }
                log.info("Creating NoOpWebResourceMapper since PrebakeConfig is not present. Pre-baked CT-CDN is disabled but will fall back to product's CDN Strategy, if any.");
                return new NoOpWebResourceMapper(new Exception("PrebakeConfig not present"));
            }
            log.info("Creating NoOpWebResourceMapper since WebResourceIntegration#isCtCdnMappingEnabled flag is disabled. Pre-baked CT-CDN is disabled but will fall back to product's CDN Strategy, if any.");
            return new NoOpWebResourceMapper(new Exception("CT-CDN is explicitly disabled by the product."));
        }
    };
    private final CdnResourceUrlTransformer cdnResourceUrlTransformer;
    private final ResourceCompiler resourceCompiler;
    public static final String INCREMENTAL_CACHE_SIZE = "plugin.webresource.incrementalcache.size";
    private final int urlCacheSize;
    private final boolean isUrlCachingEnabled;
    private boolean syncContextCreated;

    public Config(ResourceBatchingConfiguration batchingConfiguration, WebResourceIntegration integration, WebResourceUrlProvider urlProvider, ServletContextFactory servletContextFactory, TransformerCache transformerCache, ResourceCompiler resourceCompiler) {
        this.batchingConfiguration = batchingConfiguration;
        this.integration = integration;
        this.urlProvider = urlProvider;
        this.servletContextFactory = servletContextFactory;
        this.transformerCache = transformerCache;
        this.isContentCacheEnabled = Flags.isFileCacheEnabled();
        this.contentCacheSize = Flags.getFileCacheSize(1000);
        this.isUrlCachingEnabled = !Boolean.getBoolean(DISABLE_URL_CACHING);
        this.urlCacheSize = Flags.getFileCacheSize(200);
        this.incrementalCacheSize = Integer.getInteger(INCREMENTAL_CACHE_SIZE, 1000);
        this.cdnResourceUrlTransformer = new CdnResourceUrlTransformerImpl(this);
        this.resourceCompiler = resourceCompiler == null ? new NoOpResourceCompiler() : resourceCompiler;
        this.usePluginInstallTimeInsteadOfTheVersionForSnapshotPlugins = integration.usePluginInstallTimeInsteadOfTheVersionForSnapshotPlugins();
        this.syncContextCreated = false;
    }

    public void setContentTypeResolver(ContentTypeResolver contentTypeResolver) {
        if (this.contentTypeResolver != null) {
            throw new RuntimeException("content type resolver already set!");
        }
        this.contentTypeResolver = contentTypeResolver;
    }

    public void setStaticTransformers(StaticTransformers staticTransformers) {
        if (this.staticTransformers != null) {
            throw new RuntimeException("static transformers already set!");
        }
        this.staticTransformers = staticTransformers;
    }

    public boolean isContentCacheEnabled() {
        return this.isContentCacheEnabled;
    }

    public int getContentCacheSize() {
        return this.contentCacheSize;
    }

    public int getIncrementalCacheSize() {
        return this.incrementalCacheSize;
    }

    public File getCacheDirectory() {
        return this.integration.getTemporaryDirectory();
    }

    public boolean isSourceMapEnabledFor(String typeOrContentType) {
        return this.isSourceMapEnabled() && Util.isSourceMapSupportedBy((String)typeOrContentType);
    }

    public boolean isSourceMapEnabled() {
        return this.batchingConfiguration.isSourceMapEnabled();
    }

    public boolean isCdnEnabled() {
        return null != this.integration.getCDNStrategy() && this.integration.getCDNStrategy().supportsCdn();
    }

    public String getBaseUrl() {
        return this.getBaseUrl(true);
    }

    public String getBaseUrl(boolean isAbsolute) {
        try {
            return BaseRouter.joinWithSlashWithoutEmpty(this.urlProvider.getBaseUrl(isAbsolute ? UrlMode.ABSOLUTE : UrlMode.RELATIVE), DOWNLOAD_PARAM_VALUE);
        }
        catch (AssertionError e) {
            if (isAbsolute && ((Throwable)((Object)e)).getMessage().contains("Unsupported URLMode")) {
                return this.getBaseUrl(false);
            }
            throw e;
        }
    }

    public String getResourceUrlPrefix(String hash, String version, boolean isAbsolute) {
        return this.urlProvider.getStaticResourcePrefix(hash, version, isAbsolute ? UrlMode.ABSOLUTE : UrlMode.RELATIVE) + "/" + DOWNLOAD_PARAM_VALUE;
    }

    public String getResourceCdnPrefix(String url) {
        return this.getWebResourceMapper().mapSingle(url).orElseGet(() -> this.integration.getCDNStrategy().transformRelativeUrl(url));
    }

    public String getContentType(String path) {
        return this.contentTypeResolver.getContentType(path);
    }

    public ResourceContentAnnotator getContentAnnotator(String type) {
        ArrayList<ResourceContentAnnotator> annotators = new ArrayList<ResourceContentAnnotator>();
        if (JS_TYPE.equals(type)) {
            annotators.add(new SemicolonResourceContentAnnotator());
            if (this.isJavaScriptTryCatchWrappingEnabled()) {
                annotators.add(new TryCatchJsResourceContentAnnotator());
            }
            if (this.useAsyncAttributeForScripts()) {
                annotators.add(new AsyncLoaderAnnotator());
            }
            annotators.add(new LocationContentAnnotator());
            annotators.add(new ModuleAnnotator());
        } else if (CSS_TYPE.equals(type)) {
            annotators.add(new LocationContentAnnotator());
        }
        return new ListOfAnnotators(annotators);
    }

    public boolean useAsyncAttributeForScripts() {
        return this.integration.useAsyncAttributeForScripts();
    }

    private List<CompleteWebResourceKey> getSyncWebResourceKeys() {
        return new ArrayList<CompleteWebResourceKey>((Collection)MoreObjects.firstNonNull(this.integration.getSyncWebResourceKeys(), Collections.emptyList()));
    }

    public StaticTransformers getStaticTransformers() {
        return this.staticTransformers;
    }

    public static boolean isContextKey(String key) {
        return key.contains(CONTEXT_PREFIX);
    }

    public static String virtualContextKeyToWebResourceKey(String virtualContextKey) {
        return virtualContextKey.replace("_context:", "");
    }

    protected void ensureNoLegacyStuff(Snapshot snapshot) {
        if (this.integration.forbidCondition1AndTransformer1()) {
            LinkedList<String> resourcesWithLegacyConditions = new LinkedList<String>();
            for (Bundle bundle : snapshot.getWebResourcesWithLegacyConditions()) {
                if (this.integration.allowedCondition1Keys().contains(bundle.getKey())) continue;
                resourcesWithLegacyConditions.add(bundle.getKey());
            }
            LinkedList<String> resourcesWithLegacyTransformers = new LinkedList<String>();
            for (Bundle bundle : snapshot.getWebResourcesWithLegacyTransformers()) {
                if (this.integration.allowedTransform1Keys().contains(bundle.getKey())) continue;
                resourcesWithLegacyTransformers.add(bundle.getKey());
            }
            if (resourcesWithLegacyConditions.size() > 0 || resourcesWithLegacyTransformers.size() > 0) {
                ArrayList<String> arrayList = new ArrayList<String>();
                if (resourcesWithLegacyConditions.size() > 0) {
                    arrayList.add("legacy conditions: \"" + Joiner.on((String)"\", \"").join(resourcesWithLegacyConditions) + "\"");
                }
                if (resourcesWithLegacyTransformers.size() > 0) {
                    arrayList.add("legacy transformers: \"" + Joiner.on((String)"\", \"").join(resourcesWithLegacyTransformers) + "\"");
                }
                throw new ValidationException("there are web resources with " + Joiner.on((String)", and ").join(arrayList), Collections.emptyList());
            }
        }
    }

    public boolean isSyncContextCreated() {
        return this.syncContextCreated;
    }

    public Snapshot getWebResourcesWithoutCache() {
        HashMap<WebResource, CachedTransformers> webResourcesTransformations = new HashMap<WebResource, CachedTransformers>();
        HashMap<String, Bundle> cachedBundles = new HashMap<String, Bundle>();
        HashMap<String, RootPage> rootPages = new HashMap<String, RootPage>();
        HashMap<WebResource, CachedCondition> webResourcesCondition = new HashMap<WebResource, CachedCondition>();
        HashMap<String, Deprecation> webResourceDeprecationWarnings = new HashMap<String, Deprecation>();
        HashSet<WebResource> webResourcesWithLegacyConditions = new HashSet<WebResource>();
        HashSet<WebResource> webResourcesWithLegacyTransformers = new HashSet<WebResource>();
        HashSet<WebResource> webResourcesWithDisabledMinification = new HashSet<WebResource>();
        Snapshot snapshot = new Snapshot(this, cachedBundles, rootPages, webResourcesTransformations, webResourcesCondition, webResourceDeprecationWarnings, webResourcesWithLegacyConditions, webResourcesWithLegacyTransformers, webResourcesWithDisabledMinification);
        HashMap<String, IntermediaryContextData> intermediaryContexts = new HashMap<String, IntermediaryContextData>();
        ConditionInstanceCache conditionInstanceCache = new ConditionInstanceCache();
        List webResourceDescriptors = this.integration.getPluginAccessor().getEnabledModuleDescriptorsByClass(WebResourceModuleDescriptor.class);
        for (WebResourceModuleDescriptor webResourceModuleDescriptor : webResourceDescriptors) {
            if (webResourceModuleDescriptor == null || !webResourceModuleDescriptor.isDeprecated()) continue;
            String completeKey = webResourceModuleDescriptor.getCompleteKey();
            webResourceDeprecationWarnings.put(completeKey, webResourceModuleDescriptor.getDeprecation());
        }
        for (WebResourceModuleDescriptor webResourceModuleDescriptor : webResourceDescriptors) {
            Object msg;
            Object resourceLocation2;
            if (webResourceModuleDescriptor == null) continue;
            boolean isRootPage = webResourceModuleDescriptor.isRootPage();
            Plugin plugin = webResourceModuleDescriptor.getPlugin();
            Date updatedAt = plugin.getDateLoaded() == null ? new Date() : plugin.getDateLoaded();
            String completeKey = webResourceModuleDescriptor.getCompleteKey();
            DecoratingCondition condition = webResourceModuleDescriptor.getCondition();
            boolean hasLegacyConditions = condition != null && !condition.canEncodeStateIntoUrl();
            List<WebResourceTransformation> transformations = webResourceModuleDescriptor.getTransformations();
            boolean hasLegacyTransformers = false;
            for (WebResourceTransformation webResourceTransformation : transformations) {
                if (webResourceTransformation.containsOnlyPureUrlReadingTransformers(this.transformerCache)) continue;
                hasLegacyTransformers = true;
                break;
            }
            HashMap<String, Set<String>> locationResourceTypes = new HashMap<String, Set<String>>();
            for (Object resourceLocation2 : Config.getResourceLocations(webResourceModuleDescriptor, this.integration.isCompiledResourceEnabled())) {
                String nameType = ResourceUtils.getType(resourceLocation2.getName());
                String locationType = ResourceUtils.getType(resourceLocation2.getLocation());
                String nameOrLocationType = nameType.isEmpty() ? locationType : nameType;
                HashSet<String> list = (HashSet<String>)locationResourceTypes.get(nameOrLocationType);
                if (list == null) {
                    list = new HashSet<String>();
                    locationResourceTypes.put(nameOrLocationType, list);
                }
                list.add(locationType);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String key : webResourceModuleDescriptor.getDependencies()) {
                if (rootPages.containsKey(key)) {
                    msg = "invalid dependency found for \"" + completeKey + "\": \"" + key + "\" cannot be as a dependency because it is tagged as a root-page and will be ignored.";
                    this.supportLogger.error((String)msg);
                    continue;
                }
                if (!Config.isWebResourceKey(key)) {
                    this.supportLogger.warn("the dependency \"" + key + "\" doesn't look like the key of the web resource and will be ignored.");
                    continue;
                }
                if (webResourceDeprecationWarnings.containsKey(key)) {
                    msg = ((Deprecation)webResourceDeprecationWarnings.get(key)).buildLogMessage() + " (required by \"" + completeKey + "\")";
                    if (Flags.isDevMode()) {
                        this.supportLogger.warn((String)msg);
                    } else {
                        this.supportLogger.debug((String)msg);
                    }
                }
                arrayList.add(key);
            }
            for (String key : webResourceModuleDescriptor.getModuleDependencies()) {
                if (Config.isWebResourceKey(key)) {
                    this.supportLogger.warn("the module dependency \"" + key + "\" look like the key of the web resource and will be ignored.");
                    continue;
                }
                arrayList.add(key);
            }
            resourceLocation2 = webResourceModuleDescriptor.getContextDependencies().iterator();
            while (resourceLocation2.hasNext()) {
                String key;
                key = (String)resourceLocation2.next();
                if (!isRootPage) {
                    msg = "ignoring dependency \"" + key + "\" in \"" + completeKey + "\": context dependencies are only supported in root-pages at the moment";
                    this.supportLogger.error((String)msg);
                    continue;
                }
                if (Config.isWebResourceKey(key)) {
                    this.supportLogger.warn("the context dependency \"" + key + "\" look like the key of the web resource and will be ignored.");
                    continue;
                }
                arrayList.add("_context:" + key);
            }
            TransformerParameters transformerParameters = new TransformerParameters(webResourceModuleDescriptor.getPluginKey(), webResourceModuleDescriptor.getKey(), null);
            WebResource webResource = new WebResource(snapshot, completeKey, arrayList, updatedAt, Config.getPluginVersionOrInstallTime(plugin, this.usePluginInstallTimeInsteadOfTheVersionForSnapshotPlugins), true, transformerParameters, locationResourceTypes);
            cachedBundles.put(completeKey, webResource);
            if (isRootPage) {
                RootPage rootPage = new RootPage(webResource);
                rootPages.put(completeKey, rootPage);
            }
            if (hasLegacyConditions) {
                webResourcesWithLegacyConditions.add(webResource);
            }
            if (hasLegacyTransformers) {
                webResourcesWithLegacyTransformers.add(webResource);
            }
            if (webResourceModuleDescriptor.isDisableMinification()) {
                webResourcesWithDisabledMinification.add(webResource);
            }
            if (isRootPage && webResourceModuleDescriptor.getContexts().size() > 1) {
                msg = "web-resource \"" + completeKey + "\" cannot be added to a context because it's tagged as a root-page";
                this.supportLogger.error((String)msg);
                throw new RuntimeException((String)msg);
            }
            for (String context : webResourceModuleDescriptor.getContexts()) {
                if (context.equals(completeKey)) continue;
                String contextResourceKey = "_context:" + context;
                IntermediaryContextData contextData = (IntermediaryContextData)intermediaryContexts.get(contextResourceKey);
                if (contextData == null) {
                    contextData = new IntermediaryContextData();
                    intermediaryContexts.put(contextResourceKey, contextData);
                }
                contextData.dependencies.add(completeKey);
            }
            if (condition != null) {
                CachedCondition cachedCondition = conditionInstanceCache.intern(condition);
                webResourcesCondition.put(webResource, cachedCondition);
            }
            if (transformations.isEmpty()) continue;
            webResourcesTransformations.put(webResource, new CachedTransformers(transformations));
        }
        if (this.amdEnabled()) {
            this.parseModules(snapshot, cachedBundles, conditionInstanceCache, webResourcesCondition, webResourcesTransformations, intermediaryContexts);
        }
        for (Map.Entry entry : intermediaryContexts.entrySet()) {
            String contextResourceKey = (String)entry.getKey();
            IntermediaryContextData contextData = (IntermediaryContextData)entry.getValue();
            this.updateContextData(cachedBundles, contextData);
            cachedBundles.put(contextResourceKey, new Context(snapshot, contextResourceKey, contextData.dependencies, contextData.moduleDependencies, contextData.updatedAt, contextData.version, true));
        }
        List<String> syncWebResourceKeys = this.getSyncWebResourceKeys().stream().map(CompleteWebResourceKey::getCompleteKey).collect(Collectors.toList());
        if (!syncWebResourceKeys.isEmpty()) {
            this.addSpecialContext(snapshot, cachedBundles, SYNCBATCH_KEY, syncWebResourceKeys);
            this.syncContextCreated = true;
        }
        if (this.isSuperBatchingEnabled()) {
            ArrayList<String> arrayList = new ArrayList<String>(this.getBeforeAllResources());
            arrayList.addAll(this.batchingConfiguration.getSuperBatchModuleCompleteKeys());
            this.addSpecialContext(snapshot, cachedBundles, SUPERBATCH_KEY, arrayList);
        }
        for (CachedTransformers cachedTransformers : webResourcesTransformations.values()) {
            cachedTransformers.computeParamKeys(this.transformerCache);
        }
        this.ensureNoLegacyStuff(snapshot);
        return snapshot;
    }

    protected void parseModules(Snapshot snapshot, Map<String, Bundle> cachedBundles, ConditionInstanceCache conditionInstanceCache, Map<WebResource, CachedCondition> webResourcesCondition, Map<WebResource, CachedTransformers> webResourcesTransformations, Map<String, IntermediaryContextData> intermediaryContexts) {
        List modulesDescriptors = this.integration.getPluginAccessor().getEnabledModuleDescriptorsByClass(ModulesDescriptor.class);
        ArrayList<WebResourceTransformation> defaultTransformations = new ArrayList<WebResourceTransformation>();
        for (TransformationDto transformationDto : this.integration.getDefaultAmdModuleTransformers()) {
            defaultTransformations.add(new WebResourceTransformation(transformationDto));
        }
        HashMap<String, Map<String, List<WebModuleDescriptor>>> groupedModuleDescriptorsList = new HashMap<String, Map<String, List<WebModuleDescriptor>>>();
        for (ModulesDescriptor modulesDescriptor : modulesDescriptors) {
            Plugin plugin = modulesDescriptor.getPlugin();
            Map groupedModuleDescriptors = (Map)groupedModuleDescriptorsList.get(plugin.getKey());
            if (groupedModuleDescriptors != null) continue;
            try {
                groupedModuleDescriptors = this.parseAtlassianModules(plugin);
            }
            catch (RuntimeException e) {
                this.supportLogger.error("can't parse atlassian-modules.xml for \"" + plugin.getKey() + "\"", (Throwable)e);
                groupedModuleDescriptors = new HashMap<String, List<WebModuleDescriptor>>();
            }
            groupedModuleDescriptorsList.put(plugin.getKey(), groupedModuleDescriptors);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map groupedModuleDescriptors : groupedModuleDescriptorsList.values()) {
            for (List moduleDescriptors : groupedModuleDescriptors.values()) {
                for (WebModuleDescriptor moduleDescriptor : moduleDescriptors) {
                    if (!SOY_TYPE.equals(moduleDescriptor.srcType)) continue;
                    for (String soyTemplate : moduleDescriptor.soyTemplates) {
                        String existingModule = (String)hashMap.get(soyTemplate);
                        if (existingModule != null && !moduleDescriptor.name.equals(existingModule)) {
                            this.supportLogger.error("SOY template with same names exists in two different files " + existingModule + " and " + moduleDescriptor.name);
                            continue;
                        }
                        hashMap.put(soyTemplate, moduleDescriptor.name);
                    }
                }
            }
        }
        for (ModulesDescriptor modulesDescriptor : modulesDescriptors) {
            DecoratingCondition condition;
            Plugin plugin = modulesDescriptor.getPlugin();
            Date updatedAt = plugin.getDateLoaded() == null ? new Date() : plugin.getDateLoaded();
            String version = Config.getPluginVersionOrInstallTime(plugin, this.usePluginInstallTimeInsteadOfTheVersionForSnapshotPlugins);
            Map groupedModuleDescriptors = (Map)groupedModuleDescriptorsList.get(plugin.getKey());
            List moduleDescriptors = (List)groupedModuleDescriptors.get(modulesDescriptor.getDir());
            if (moduleDescriptors == null) continue;
            CachedCondition cachedCondition = null;
            if (this.useConditionsForWebModules() && (condition = modulesDescriptor.getCondition()) != null && (cachedCondition = conditionInstanceCache.intern(condition)).isLegacy()) {
                throw new RuntimeException("legacy condition not allowed for " + plugin.getKey() + " " + modulesDescriptor.getDir() + " module!");
            }
            List<WebResourceTransformation> transformations = modulesDescriptor.getTransformations();
            for (WebResourceTransformation transformation : transformations) {
                if (transformation.containsOnlyPureUrlReadingTransformers(this.transformerCache)) continue;
                throw new RuntimeException("legacy transformers not allowed for " + plugin.getKey() + " " + modulesDescriptor.getDir() + " module!");
            }
            for (WebModuleDescriptor moduleDescriptor : moduleDescriptors) {
                LinkedHashMap<String, String> unresolvedDependencies = new LinkedHashMap<String, String>();
                ArrayList<String> dependencies = new ArrayList<String>();
                LinkedHashSet<String> webResourceDependencies = new LinkedHashSet<String>();
                for (Map.Entry<String, WebModuleDescriptor.Dependency> entry : moduleDescriptor.dependencies.entrySet()) {
                    String dependencyName = entry.getKey();
                    WebModuleDescriptor.Dependency dependency = entry.getValue();
                    if (WEB_RESOURCE_MODULE_LOADER.equals(dependency.loader)) {
                        webResourceDependencies.add(dependency.name);
                    } else if (Config.isWebResourceKey(dependency.name)) {
                        this.supportLogger.warn("module \"" + moduleDescriptor.name + "\" references web resource \"" + dependency.name + "\" without `wr!` prefix, dependency will be ignored!");
                        continue;
                    }
                    dependencies.add(Config.nameAndLoaderToNameWithExtension(dependency.loader, dependency.resolvedName));
                    String resolvedNameWithLoader = Config.nameAndLoaderToNameWithLoader(dependency.loader, dependency.resolvedName);
                    if (dependency.name.equals(resolvedNameWithLoader)) continue;
                    unresolvedDependencies.put(dependencyName, resolvedNameWithLoader);
                }
                if (SOY_TYPE.equals(moduleDescriptor.srcType)) {
                    for (String soyDependency : moduleDescriptor.soyDependencies) {
                        String soyDependencyAmdName = (String)hashMap.get(soyDependency);
                        if (soyDependencyAmdName == null || soyDependencyAmdName.equals(moduleDescriptor.name) || dependencies.contains(soyDependencyAmdName)) continue;
                        dependencies.add(soyDependencyAmdName);
                    }
                }
                String moduleName = JS_TYPE.equals(moduleDescriptor.srcType) ? moduleDescriptor.baseName : moduleDescriptor.name;
                String fileType = ResourceUtils.getType(moduleDescriptor.filePath);
                HashMap<String, Set<String>> locationResourceTypes = new HashMap<String, Set<String>>();
                HashSet<String> types = new HashSet<String>();
                types.add(fileType);
                locationResourceTypes.put(moduleDescriptor.type, types);
                WebModule module = new WebModule(snapshot, plugin.getKey(), moduleName, moduleDescriptor.baseName, dependencies, unresolvedDependencies, webResourceDependencies, updatedAt, version, new TransformerParameters(plugin.getKey(), "", moduleDescriptor.filePath), moduleDescriptor.filePath, moduleDescriptor.type, moduleDescriptor.srcType, moduleDescriptor.soyNamespace, locationResourceTypes);
                cachedBundles.put(moduleName, module);
                if (this.useConditionsForWebModules() && cachedCondition != null) {
                    webResourcesCondition.put(module, cachedCondition);
                }
                ArrayList<WebResourceTransformation> allTransformations = new ArrayList<WebResourceTransformation>(defaultTransformations);
                allTransformations.addAll(transformations);
                if (!allTransformations.isEmpty()) {
                    webResourcesTransformations.put(module, new CachedTransformers(allTransformations));
                }
                for (String context : moduleDescriptor.contexts) {
                    String contextResourceKey = "_context:" + context;
                    IntermediaryContextData contextData = intermediaryContexts.get(contextResourceKey);
                    if (contextData == null) {
                        contextData = new IntermediaryContextData();
                        intermediaryContexts.put(contextResourceKey, contextData);
                    }
                    contextData.dependencies.add(moduleName);
                    contextData.moduleDependencies.add(moduleName);
                }
            }
        }
    }

    public static Tuple<String, String> parseNameWithLoader(String name) {
        String[] parts = name.split("!");
        if (parts.length == 1) {
            return new Tuple<Object, String>(null, parts[0]);
        }
        if (parts.length == 2) {
            return new Tuple<String, String>(parts[0], parts[1]);
        }
        throw new RuntimeException("invalid AMD name \"" + name + "\"!");
    }

    public static String nameAndLoaderToNameWithExtension(String loader, String name) {
        return loader == null || JS_TYPE.equals(loader) || WEB_RESOURCE_MODULE_LOADER.equals(loader) ? name : name + "." + loader;
    }

    public static String nameAndLoaderToNameWithLoader(String loader, String name) {
        return loader == null || JS_TYPE.equals(loader) ? name : loader + "!" + name;
    }

    private void addSpecialContext(Snapshot snapshot, Map<String, Bundle> bundles, String key, List<String> dependencies) {
        IntermediaryContextData contextData = new IntermediaryContextData();
        contextData.updatedAt = new Date(0L);
        contextData.dependencies = dependencies;
        this.updateContextData(bundles, contextData);
        bundles.put(key, new Bundle(snapshot, key, dependencies, contextData.updatedAt, contextData.version, true));
    }

    private void updateContextData(Map<String, Bundle> bundles, IntermediaryContextData contextData) {
        for (String dependency : contextData.dependencies) {
            Bundle bundle = bundles.get(dependency);
            if (null == bundle) continue;
            Date updatedAt = bundle.getUpdatedAt();
            String version = bundle.getVersion();
            if (contextData.updatedAt == null || contextData.updatedAt.before(updatedAt)) {
                contextData.updatedAt = updatedAt;
            }
            contextData.version = HashBuilder.buildHash(contextData.version, version);
        }
    }

    protected Map<String, List<WebModuleDescriptor>> parseAtlassianModules(Plugin plugin) {
        String xmlData;
        InputStream stream = plugin.getResourceAsStream(ATLASSIAN_MODULES_XML);
        if (stream == null) {
            this.supportLogger.error("no atlassian-modules.xml for \"" + plugin.getKey() + "\" plugin!");
            return new HashMap<String, List<WebModuleDescriptor>>();
        }
        try {
            xmlData = CharStreams.toString((Readable)new InputStreamReader(stream, Charsets.UTF_8));
        }
        catch (IOException e) {
            this.supportLogger.error("can't read atlassian-modules.xml for " + plugin.getKey(), (Throwable)e);
            return new HashMap<String, List<WebModuleDescriptor>>();
        }
        Element modulesEl = Support.parseXml(xmlData);
        int version = Integer.parseInt(modulesEl.attributeValue("version"));
        if (version != 2) {
            this.supportLogger.error("wrong version of atlassian-modules.xml for \"" + plugin.getKey() + "\"");
            return new HashMap<String, List<WebModuleDescriptor>>();
        }
        HashMap<String, List<WebModuleDescriptor>> groupedModuleDescriptors = new HashMap<String, List<WebModuleDescriptor>>();
        for (Object moduleElAsObject : modulesEl.elements()) {
            Element moduleEl = (Element)moduleElAsObject;
            List dependencyEls = moduleEl.elements("dependency");
            LinkedHashMap<String, WebModuleDescriptor.Dependency> dependencies = new LinkedHashMap<String, WebModuleDescriptor.Dependency>();
            for (Element dependency : dependencyEls) {
                String name = dependency.getTextTrim();
                dependencies.put(name, new WebModuleDescriptor.Dependency(name, dependency.attributeValue("resolved-name"), dependency.attributeValue("loader")));
            }
            List contextEls = moduleEl.elements("context");
            ArrayList<String> contexts = new ArrayList<String>();
            for (Element context : contextEls) {
                contexts.add(context.getTextTrim());
            }
            List soyTemplateEls = moduleEl.elements("soy-template");
            ArrayList<String> soyTemplates = new ArrayList<String>();
            for (Element soyTemplate : soyTemplateEls) {
                soyTemplates.add(soyTemplate.getTextTrim());
            }
            List soyDependencyEls = moduleEl.elements("soy-dependency");
            ArrayList<String> soyDependencies = new ArrayList<String>();
            for (Element soyDependency : soyDependencyEls) {
                soyDependencies.add(soyDependency.getTextTrim());
            }
            String modulesDescriptorDir = moduleEl.attributeValue("modules-descriptor-dir");
            ArrayList<WebModuleDescriptor> modules = (ArrayList<WebModuleDescriptor>)groupedModuleDescriptors.get(modulesDescriptorDir);
            if (modules == null) {
                modules = new ArrayList<WebModuleDescriptor>();
                groupedModuleDescriptors.put(modulesDescriptorDir, modules);
            }
            modules.add(new WebModuleDescriptor(moduleEl.attributeValue("name"), moduleEl.attributeValue("base-name"), moduleEl.attributeValue("type"), moduleEl.attributeValue("src-type"), moduleEl.attributeValue("file-path"), dependencies, contexts, soyTemplates, soyDependencies, moduleEl.attributeValue("soy-namespace")));
        }
        return groupedModuleDescriptors;
    }

    public LinkedHashMap<String, Resource> getResourcesWithoutCache(Bundle bundle) {
        LinkedHashMap<String, Resource> resources = new LinkedHashMap<String, Resource>();
        WebResourceModuleDescriptor webResourceDescriptor = this.getWebResourceModuleDescriptor(bundle.getKey());
        if (webResourceDescriptor != null) {
            for (ResourceLocation resourceLocation : Config.getResourceLocations(webResourceDescriptor, this.integration.isCompiledResourceEnabled())) {
                Resource resource = this.buildResource(bundle, resourceLocation);
                resources.put(resource.getName(), resource);
            }
        }
        return resources;
    }

    protected static List<ResourceLocation> getResourceLocations(WebResourceModuleDescriptor webResourceModuleDescriptor, boolean compiledResourcesEnabled) {
        ArrayList<ResourceLocation> resourceDescriptors = new ArrayList<ResourceLocation>();
        for (ResourceDescriptor resourceDescriptor : webResourceModuleDescriptor.getResourceDescriptors()) {
            String compiledLocation;
            if (!DOWNLOAD_PARAM_VALUE.equals(resourceDescriptor.getType())) continue;
            ResourceLocation resourceLocation = resourceDescriptor.getResourceLocationForName(null);
            if (compiledResourcesEnabled && (compiledLocation = resourceDescriptor.getParameter(COMPILED_RESOURCE_LOCATION_PARAMETER)) != null) {
                ResourceLocation newLocation;
                resourceLocation = newLocation = new ResourceLocation(compiledLocation, resourceLocation.getName(), resourceLocation.getType(), resourceLocation.getContentType(), resourceLocation.getContent(), resourceLocation.getParams());
            }
            resourceDescriptors.add(resourceLocation);
        }
        return resourceDescriptors;
    }

    public LinkedHashMap<String, Jsonable> getWebResourceData(String key) {
        LinkedHashMap<String, Jsonable> data = new LinkedHashMap<String, Jsonable>();
        WebResourceModuleDescriptor webResourceDescriptor = this.getWebResourceModuleDescriptor(key);
        if (webResourceDescriptor != null) {
            for (Map.Entry<String, WebResourceDataProvider> entry : webResourceDescriptor.getDataProviders().entrySet()) {
                data.put(entry.getKey(), (Jsonable)entry.getValue().get());
            }
        }
        return data;
    }

    private WebResourceModuleDescriptor getWebResourceModuleDescriptor(String key) {
        ModuleDescriptor moduleDescriptor;
        try {
            moduleDescriptor = this.integration.getPluginAccessor().getEnabledPluginModule(key);
        }
        catch (RuntimeException e) {
            moduleDescriptor = null;
        }
        if (moduleDescriptor == null) {
            return null;
        }
        if (!(moduleDescriptor instanceof WebResourceModuleDescriptor)) {
            return null;
        }
        return (WebResourceModuleDescriptor)moduleDescriptor;
    }

    public InputStream getStreamFor(Resource resource, String path) {
        if (resource instanceof ModuleResource) {
            return this.getPlugin(((ModuleResource)resource).getPluginKey()).getResourceAsStream(path);
        }
        ResourceLocation resourceLocation = resource.getResourceLocation();
        String sourceParam = resourceLocation.getParameter(SOURCE_PARAM_NAME);
        boolean isWebContextStatic = "webContextStatic".equalsIgnoreCase(sourceParam);
        if (isWebContextStatic) {
            String pathWithSlash = path.startsWith("/") ? path : "/" + path;
            return this.servletContextFactory.getServletContext().getResourceAsStream(pathWithSlash);
        }
        return this.getPlugin(resource.getKey()).getResourceAsStream(path);
    }

    private Plugin getPlugin(String key) {
        if (key.contains(":")) {
            ModuleDescriptor moduleDescriptor = this.integration.getPluginAccessor().getEnabledPluginModule(key);
            return (Plugin)Preconditions.checkNotNull((Object)moduleDescriptor.getPlugin());
        }
        return (Plugin)Preconditions.checkNotNull((Object)this.integration.getPluginAccessor().getEnabledPlugin(key));
    }

    public boolean isMinificationEnabled() {
        return !Boolean.getBoolean(DISABLE_MINIFICATION) && !Flags.isDevMode();
    }

    protected Resource buildResource(Bundle bundle, ResourceLocation resourceLocation) {
        return new Resource(bundle, resourceLocation, ResourceUtils.getType(resourceLocation.getName()), ResourceUtils.getType(resourceLocation.getLocation()));
    }

    public Resource getModuleResource(String completeKey, String name) {
        if (!Config.isWebResourceKey(completeKey)) {
            return null;
        }
        ModuleDescriptor moduleDescriptor = this.integration.getPluginAccessor().getEnabledPluginModule(completeKey);
        if (moduleDescriptor == null) {
            return null;
        }
        ResourceLocation resourceLocation = moduleDescriptor.getResourceLocation(DOWNLOAD_PARAM_VALUE, name);
        if (resourceLocation == null) {
            return null;
        }
        Plugin plugin = moduleDescriptor.getPlugin();
        Date updatedAt = plugin.getDateLoaded() == null ? new Date() : plugin.getDateLoaded();
        PluginResourceContainer resourceContainer = new PluginResourceContainer(new Snapshot(this), completeKey, updatedAt, Config.getPluginVersionOrInstallTime(plugin, this.usePluginInstallTimeInsteadOfTheVersionForSnapshotPlugins));
        return this.buildResource(resourceContainer, resourceLocation);
    }

    public Resource getPluginResource(String pluginKey, String name) {
        Plugin plugin = this.integration.getPluginAccessor().getPlugin(pluginKey);
        if (plugin == null) {
            return null;
        }
        ResourceLocation resourceLocation = plugin.getResourceLocation(DOWNLOAD_PARAM_VALUE, name);
        if (resourceLocation == null) {
            return null;
        }
        PluginResourceContainer resourceContainer = new PluginResourceContainer(new Snapshot(this), pluginKey, plugin.getDateLoaded(), Config.getPluginVersionOrInstallTime(plugin, this.usePluginInstallTimeInsteadOfTheVersionForSnapshotPlugins));
        Resource resource = this.buildResource(resourceContainer, resourceLocation);
        return resource;
    }

    public boolean optimiseSourceMapsForDevelopment() {
        return this.batchingConfiguration.optimiseSourceMapsForDevelopment();
    }

    public boolean isSuperBatchingEnabled() {
        return this.batchingConfiguration.isSuperBatchingEnabled();
    }

    public boolean isBatchContentTrackingEnabled() {
        return this.batchingConfiguration.isBatchContentTrackingEnabled();
    }

    public boolean isContextBatchingEnabled() {
        return this.batchingConfiguration.isContextBatchingEnabled();
    }

    public boolean isWebResourceBatchingEnabled() {
        return this.batchingConfiguration.isPluginWebResourceBatchingEnabled();
    }

    public boolean isIncrementalCacheEnabled() {
        return this.integration.isIncrementalCacheEnabled();
    }

    public static boolean isWebResourceKey(String completeKey) {
        return completeKey.contains(":");
    }

    public int partialHashCode() {
        return this.integration.getSuperBatchVersion().hashCode();
    }

    @Deprecated
    public WebResourceIntegration getIntegration() {
        return this.integration;
    }

    @Deprecated
    public TransformerCache getTransformerCache() {
        return this.transformerCache;
    }

    public boolean isUrlGenerationCacheEnabled() {
        return true;
    }

    public int getUrlCacheSize() {
        return this.urlCacheSize;
    }

    @Deprecated
    public ResourceBatchingConfiguration getBatchingConfiguration() {
        return this.batchingConfiguration;
    }

    public boolean isDeferJsAttributeEnabled() {
        return this.integration.isDeferJsAttributeEnabled();
    }

    public TimeSpan getDefaultBigPipeDeadline() {
        return this.integration.getBigPipeConfiguration().getDefaultBigPipeDeadline();
    }

    public boolean getBigPipeDeadlineDisabled() {
        return this.integration.getBigPipeConfiguration().getBigPipeDeadlineDisabled();
    }

    public String computeGlobalStateHash() {
        LinkedList<String> state = new LinkedList<String>();
        state.add("productver");
        state.add(this.integration.getHostApplicationVersion());
        state.add("annotators");
        state.add(String.valueOf(this.getContentAnnotator(JS_TYPE).hashCode()));
        state.add(String.valueOf(this.getContentAnnotator(CSS_TYPE).hashCode()));
        state.add("plugins");
        ArrayList plugins = new ArrayList(this.integration.getPluginAccessor().getEnabledPlugins());
        Collections.sort(plugins, this.consistentPluginOrder());
        for (Plugin plugin : plugins) {
            state.add(plugin.getKey());
            state.add(Config.getPluginVersionOrInstallTime(plugin, this.usePluginInstallTimeInsteadOfTheVersionForSnapshotPlugins));
        }
        String globalProductStateHash = HashBuilder.buildHash(state);
        log.info("Calculated global state hash {} based on {}", (Object)globalProductStateHash, state);
        return globalProductStateHash;
    }

    private Comparator<Plugin> consistentPluginOrder() {
        return Comparator.comparing(p -> p.getKey() + "-" + Config.getPluginVersionOrInstallTime(p, this.usePluginInstallTimeInsteadOfTheVersionForSnapshotPlugins));
    }

    public boolean useConditionsForWebModules() {
        return false;
    }

    public List<String> getBeforeAllResources() {
        return this.amdEnabled() ? BEFORE_ALL_AMD_RESOURCES : Collections.emptyList();
    }

    public CdnResourceUrlTransformer getCdnResourceUrlTransformer() {
        return this.cdnResourceUrlTransformer;
    }

    public boolean isPreBakeEnabled() {
        return Boolean.getBoolean(PREBAKE_FEATURE_ENABLED);
    }

    public static boolean isStaticContextOrderEnabled() {
        return Boolean.getBoolean(STATIC_CONTEXT_ORDER_ENABLED);
    }

    public boolean isGlobalMinificationEnabled() {
        return this.isMinificationEnabled() && Boolean.getBoolean(GLOBAL_MINIFICATION_ENABLED);
    }

    public String getCtCdnBaseUrl() {
        return System.getProperty(CT_CDN_BASE_URL);
    }

    public ResourceCompiler getResourceCompiler() {
        return this.resourceCompiler;
    }

    public void runResourceCompilation(Snapshot snapshot) {
        LinkedHashSet compilerEntries = new LinkedHashSet();
        RequestCache requestCache = new RequestCache(null);
        snapshot.forEachBundle(bundle -> {
            List entries;
            LinkedHashMap<String, Resource> resources = bundle.getResources(requestCache);
            if (MapUtils.isNotEmpty(resources) && CollectionUtils.isNotEmpty(entries = resources.values().stream().filter(res -> res.getNameOrLocationType().equals(JS_TYPE)).flatMap(resource -> {
                try (InputStream in = this.getStreamFor((Resource)resource, resource.getPath());){
                    Stream stream = in != null ? Stream.of(CompilerEntry.ofKeyValue((String)resource.getPath(), (Object)IOUtils.toString((InputStream)in, (String)CompilerUtil.CHARSET.name()))) : Stream.empty();
                    return stream;
                }
                catch (IOException e) {
                    this.supportLogger.warn(String.format("Error compiling %s", resource.getKey()), (Throwable)e);
                    return Stream.empty();
                }
            }).collect(Collectors.toList()))) {
                compilerEntries.addAll(entries);
            }
        });
        this.resourceCompiler.compile(compilerEntries.stream());
    }

    public boolean resplitMergedContextBatchesForThisRequest() {
        return this.batchingConfiguration.resplitMergedContextBatchesForThisRequest();
    }

    public boolean amdEnabled() {
        return this.integration.amdEnabled();
    }

    public WebResourceMapper getWebResourceMapper() {
        return (WebResourceMapper)this.cdnUrlMapper.get();
    }

    public void reloadWebResourceMapper() throws Exception {
        NoOpWebResourceMapper noOpWebResourceMapper;
        this.cdnUrlMapper.reset();
        WebResourceMapper wrm = (WebResourceMapper)this.cdnUrlMapper.get();
        if (wrm instanceof NoOpWebResourceMapper && (noOpWebResourceMapper = (NoOpWebResourceMapper)wrm).reason().isPresent()) {
            throw noOpWebResourceMapper.reason().get();
        }
    }

    public boolean isJavaScriptTryCatchWrappingEnabled() {
        return this.batchingConfiguration.isJavaScriptTryCatchWrappingEnabled();
    }

    public static String getPluginVersionOrInstallTime(Plugin plugin, boolean usePluginInstallTimeInsteadOfTheVersionForSnapshotPlugins) {
        String version;
        PluginInformation pluginInfo = plugin.getPluginInformation();
        String string = version = pluginInfo != null ? pluginInfo.getVersion() : "unknown";
        if (usePluginInstallTimeInsteadOfTheVersionForSnapshotPlugins && SNAPSHOT_PLUGIN_REGEX.matcher(version).find()) {
            Date loadedAt = plugin.getDateLoaded() == null ? new Date() : plugin.getDateLoaded();
            return version + "-" + loadedAt.getTime();
        }
        return version;
    }

    public boolean isCSSPrebakingEnabled() {
        return Boolean.getBoolean(PREBAKE_CSS_RESOURCES);
    }

    public boolean ignorePrebakeWarnings() {
        return Boolean.getBoolean(IGNORE_PREBAKE_WARNINGS);
    }

    public boolean isUrlCachingEnabled() {
        return this.isUrlCachingEnabled;
    }

    void setLogger(Logger logger) {
        this.supportLogger = logger;
    }

    protected static class WebModuleDescriptor {
        public final String name;
        private final String baseName;
        public final String type;
        public final String srcType;
        public final String filePath;
        public final LinkedHashMap<String, Dependency> dependencies;
        public final List<String> contexts;
        public final List<String> soyTemplates;
        public final List<String> soyDependencies;
        public final String soyNamespace;

        public WebModuleDescriptor(String name, String baseName, String type, String srcType, String filePath, LinkedHashMap<String, Dependency> dependencies, List<String> contexts, List<String> soyTemplates, List<String> soyDependencies, String soyNamespace) {
            this.name = name;
            this.baseName = baseName;
            this.type = WebModuleDescriptor.validateType(name, type);
            this.srcType = WebModuleDescriptor.validateSrcType(name, srcType);
            this.filePath = filePath;
            this.dependencies = dependencies;
            this.contexts = contexts;
            this.soyTemplates = soyTemplates;
            this.soyDependencies = soyDependencies;
            this.soyNamespace = soyNamespace;
        }

        private static String validateType(String name, String type) {
            if (Config.JS_TYPE.equals(type) || Config.CSS_TYPE.equals(type)) {
                return type;
            }
            throw new RuntimeException("invalid type for " + name + " it should be js or css but instead it's \"" + type + "\"");
        }

        private static String validateSrcType(String name, String srcType) {
            if (srcType == null || StringUtils.isBlank((CharSequence)srcType)) {
                throw new RuntimeException("invalid srcType for " + name + "!");
            }
            return srcType;
        }

        protected static class Dependency {
            public final String name;
            public final String resolvedName;
            public final String loader;

            public Dependency(String name, String resolvedName, String loader) {
                this.name = name;
                this.resolvedName = resolvedName;
                this.loader = loader;
            }
        }
    }

    protected static class IntermediaryContextData {
        public List<String> dependencies = new ArrayList<String>();
        public Date updatedAt;
        public String version = "";
        public List<String> moduleDependencies = new ArrayList<String>();

        protected IntermediaryContextData() {
        }
    }
}

