/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.common.security.jersey;

import com.atlassian.http.mime.BrowserUtils;
import com.atlassian.http.mime.UserAgentUtil;
import com.atlassian.http.mime.UserAgentUtilImpl;
import com.atlassian.http.url.SameOrigin;
import com.atlassian.plugin.tracker.PluginModuleTracker;
import com.atlassian.plugins.rest.common.security.CorsHeaders;
import com.atlassian.plugins.rest.common.security.XsrfCheckFailedException;
import com.atlassian.plugins.rest.common.security.descriptor.CorsDefaults;
import com.atlassian.plugins.rest.common.security.descriptor.CorsDefaultsModuleDescriptor;
import com.atlassian.sal.api.web.context.HttpContext;
import com.atlassian.sal.api.xsrf.XsrfRequestValidator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import com.sun.jersey.spi.container.ResourceFilter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XsrfResourceFilter
implements ResourceFilter,
ContainerRequestFilter {
    public static final String TOKEN_HEADER = "X-Atlassian-Token";
    public static final String NO_CHECK = "no-check";
    private static final ImmutableSet<String> XSRFABLE_TYPES = ImmutableSet.of((Object)"application/x-www-form-urlencoded", (Object)"multipart/form-data", (Object)"text/plain");
    private static final ImmutableSet<String> BROWSER_EXTENSION_ORIGINS = ImmutableSet.of((Object)"chrome-extension", (Object)"safari-extension");
    private static final Logger log = LoggerFactory.getLogger(XsrfResourceFilter.class);
    private HttpContext httpContext;
    private XsrfRequestValidator xsrfRequestValidator;
    private PluginModuleTracker<CorsDefaults, CorsDefaultsModuleDescriptor> pluginModuleTracker;
    private Response.Status failureStatus = Response.Status.FORBIDDEN;

    public void setHttpContext(HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    public void setXsrfRequestValidator(XsrfRequestValidator xsrfRequestValidator) {
        this.xsrfRequestValidator = xsrfRequestValidator;
    }

    public void setPluginModuleTracker(PluginModuleTracker<CorsDefaults, CorsDefaultsModuleDescriptor> pluginModuleTracker) {
        this.pluginModuleTracker = pluginModuleTracker;
    }

    public void setFailureStatus(Response.Status failureStatus) {
        if (failureStatus != Response.Status.FORBIDDEN && failureStatus != Response.Status.NOT_FOUND) {
            throw new IllegalArgumentException("Only FORBIDDEN and NOT_FOUND status are valid arguments.");
        }
        this.failureStatus = failureStatus;
    }

    public ContainerRequest filter(ContainerRequest request) {
        if (this.passesAllXsrfChecks(request)) {
            return request;
        }
        throw new XsrfCheckFailedException(this.failureStatus);
    }

    private boolean passesAllXsrfChecks(ContainerRequest request) {
        if (XsrfResourceFilter.isPostRequest(request) && this.isLikelyToBeFromBrowser(request) && !this.passesAdditionalBrowserChecks(request)) {
            return false;
        }
        if (this.isXsrfable(request)) {
            boolean passes;
            boolean bl = passes = this.passesStandardXsrfChecks(XsrfResourceFilter.getRequestOrNull(this.httpContext)) || this.hasDeprecatedHeaderValue(request);
            if (passes) {
                return true;
            }
            log.warn(String.format("XSRF checks failed for request: %s , origin: %s , referrer: %s", StringUtils.substringBefore((String)request.getRequestUri().toString(), (String)"?"), request.getHeaderValue(CorsHeaders.ORIGIN.value()), XsrfResourceFilter.getSanitisedReferrer(request)));
            return false;
        }
        return true;
    }

    private boolean passesStandardXsrfChecks(HttpServletRequest httpServletRequest) {
        if (httpServletRequest == null) {
            return false;
        }
        return this.xsrfRequestValidator.validateRequestPassesXsrfChecks(httpServletRequest);
    }

    boolean isOriginABrowserExtension(String origin) {
        if (StringUtils.isEmpty((String)origin)) {
            return false;
        }
        try {
            URI originUri = new URI(origin);
            return BROWSER_EXTENSION_ORIGINS.contains((Object)originUri.getScheme()) && !originUri.isOpaque();
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    @VisibleForTesting
    protected boolean passesAdditionalBrowserChecks(ContainerRequest request) {
        URI uri;
        String origin = request.getHeaderValue(CorsHeaders.ORIGIN.value());
        String referrer = XsrfResourceFilter.getSanitisedReferrer(request);
        if (this.isSameOrigin(referrer, uri = request.getRequestUri())) {
            return true;
        }
        if (this.isSameOrigin(origin, uri)) {
            return true;
        }
        if (this.isOriginABrowserExtension(origin)) {
            return true;
        }
        boolean requestContainsCredentials = XsrfResourceFilter.containsCredentials(request);
        boolean requestAllowedViaCors = this.isAllowedViaCors(origin, requestContainsCredentials);
        if (requestAllowedViaCors) {
            return true;
        }
        log.warn(String.format("Additional XSRF checks failed for request: %s , origin: %s , referrer: %s , credentials in request: %s , allowed via CORS: %s", StringUtils.substringBefore((String)uri.toString(), (String)"?"), origin, referrer, requestContainsCredentials, requestAllowedViaCors));
        return false;
    }

    boolean isXsrfable(ContainerRequest request) {
        String method = request.getMethod();
        return method.equals("GET") || method.equals("POST") && (request.getMediaType() == null || XSRFABLE_TYPES.contains((Object)XsrfResourceFilter.mediaTypeToString(request.getMediaType())));
    }

    private boolean hasDeprecatedHeaderValue(ContainerRequest request) {
        String tokenHeader = request.getHeaderValue(TOKEN_HEADER);
        if (tokenHeader == null) {
            return false;
        }
        String normalisedTokenHeader = tokenHeader.toLowerCase(Locale.ENGLISH);
        if (normalisedTokenHeader.equals("nocheck")) {
            log.warn("Use of the 'nocheck' value for {} has been deprecated since rest 3.0.0. Please use a value of 'no-check' instead.", (Object)TOKEN_HEADER);
            return true;
        }
        return false;
    }

    private boolean isSameOrigin(String uri, URI origin) {
        try {
            return StringUtils.isNotEmpty((String)uri) && SameOrigin.isSameOrigin((URI)new URI(uri), (URI)origin);
        }
        catch (MalformedURLException e) {
            return false;
        }
        catch (URISyntaxException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private boolean isAllowedViaCors(final String originUri, final boolean withCredentials) {
        if (originUri == null) {
            return false;
        }
        return Iterables.any((Iterable)this.pluginModuleTracker.getModules(), (Predicate)new Predicate<CorsDefaults>(){

            public boolean apply(CorsDefaults delegate) {
                if (!delegate.allowsOrigin(originUri)) {
                    return false;
                }
                return !withCredentials || delegate.allowsCredentials(originUri);
            }
        });
    }

    public ContainerRequestFilter getRequestFilter() {
        return this;
    }

    public ContainerResponseFilter getResponseFilter() {
        return null;
    }

    private static boolean containsCredentials(ContainerRequest request) {
        return XsrfResourceFilter.containsCookies(request) || XsrfResourceFilter.containsHttpAuthHeader(request);
    }

    private static boolean containsCookies(ContainerRequest request) {
        return !request.getCookies().isEmpty();
    }

    private static boolean containsHttpAuthHeader(ContainerRequest request) {
        return StringUtils.isNotEmpty((String)request.getHeaderValue("Authorization"));
    }

    static boolean isPostRequest(ContainerRequest request) {
        return request.getMethod().equals("POST");
    }

    boolean isLikelyToBeFromBrowser(ContainerRequest request) {
        String userAgent = request.getHeaderValue("User-Agent");
        UserAgentUtil.BrowserFamily browserFamily = new UserAgentUtilImpl().getBrowserFamily(userAgent);
        if ((this.passesStandardXsrfChecks(XsrfResourceFilter.getRequestOrNull(this.httpContext)) || this.hasDeprecatedHeaderValue(request)) && BrowserUtils.isIE((String)userAgent)) {
            return false;
        }
        return !browserFamily.equals((Object)UserAgentUtil.BrowserFamily.UKNOWN);
    }

    private static HttpServletRequest getRequestOrNull(HttpContext httpContext) {
        return httpContext == null ? null : httpContext.getRequest();
    }

    private static String mediaTypeToString(MediaType mediaType) {
        return mediaType.getType().toLowerCase(Locale.ENGLISH) + "/" + mediaType.getSubtype().toLowerCase(Locale.ENGLISH);
    }

    private static String getSanitisedReferrer(ContainerRequest request) {
        return StringUtils.substringBefore((String)request.getHeaderValue("Referer"), (String)"?");
    }
}

