/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.profiling;

import com.atlassian.util.profiling.CompositeTicker;
import com.atlassian.util.profiling.Histogram;
import com.atlassian.util.profiling.MetricKey;
import com.atlassian.util.profiling.MetricTag;
import com.atlassian.util.profiling.MetricTimer;
import com.atlassian.util.profiling.MetricsConfiguration;
import com.atlassian.util.profiling.StrategiesRegistry;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Tickers;
import com.atlassian.util.profiling.strategy.MetricStrategy;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class Metrics {
    private static final MetricsConfiguration CONFIGURATION = new MetricsConfiguration();

    private Metrics() {
        throw new UnsupportedOperationException("Metrics is an utility class and should not be instantiated");
    }

    @Nonnull
    public static MetricsConfiguration getConfiguration() {
        return CONFIGURATION;
    }

    @Nonnull
    public static Histogram histogram(String name) {
        return new DefaultHistogram(MetricKey.metricKey(name));
    }

    @Nonnull
    public static Histogram histogram(String name, Collection<MetricTag> tags) {
        return new DefaultHistogram(MetricKey.metricKey(name, tags));
    }

    @Nonnull
    public static Histogram histogram(String name, MetricTag ... tags) {
        return new DefaultHistogram(MetricKey.metricKey(name, tags));
    }

    @Nonnull
    public static MetricTimer timer(String name) {
        return new DefaultMetricTimer(MetricKey.metricKey(name));
    }

    @Nonnull
    public static MetricTimer timer(String name, Collection<MetricTag> tags) {
        return new DefaultMetricTimer(MetricKey.metricKey(name, tags));
    }

    @Nonnull
    public static MetricTimer timer(String name, MetricTag ... tags) {
        return new DefaultMetricTimer(MetricKey.metricKey(name, tags));
    }

    @Nonnull
    public static Ticker startTimer(String name) {
        return Metrics.startTimer(name, Collections.emptySet());
    }

    @Nonnull
    public static Ticker startTimer(String name, MetricTag ... tags) {
        return Metrics.startTimer(name, Arrays.asList(tags));
    }

    @Nonnull
    public static Ticker startTimer(String name, Collection<MetricTag> tags) {
        if (CONFIGURATION.isEnabled()) {
            return Metrics.timer(name, tags).start();
        }
        return Ticker.NO_OP;
    }

    private static class DefaultHistogram
    implements Histogram {
        private static final Logger log = LoggerFactory.getLogger(DefaultHistogram.class);
        private final MetricKey metricKey;

        private DefaultHistogram(MetricKey metricKey) {
            this.metricKey = Objects.requireNonNull(metricKey, "metricKey");
        }

        @Override
        public void update(long value) {
            if (Metrics.getConfiguration().isEnabled()) {
                for (MetricStrategy strategy : StrategiesRegistry.getMetricStrategies()) {
                    try {
                        strategy.updateHistogram(this.metricKey, value);
                    }
                    catch (RuntimeException e) {
                        log.warn("Failed to update histogram for {}", (Object)this.metricKey, (Object)e);
                    }
                }
            }
        }
    }

    @ParametersAreNonnullByDefault
    private static class DefaultMetricTimer
    implements MetricTimer {
        private static final Logger log = LoggerFactory.getLogger(DefaultMetricTimer.class);
        private final MetricKey metricKey;

        DefaultMetricTimer(MetricKey name) {
            this.metricKey = Objects.requireNonNull(name, "metricKey");
        }

        @Override
        @Nonnull
        public Ticker start() {
            Collection<MetricStrategy> metricStrategies = StrategiesRegistry.getMetricStrategies();
            if (!Metrics.getConfiguration().isEnabled() || metricStrategies.isEmpty()) {
                return Ticker.NO_OP;
            }
            CompositeTicker compositeTicker = null;
            for (MetricStrategy strategy : metricStrategies) {
                try {
                    compositeTicker = Tickers.addTicker(strategy.startTimer(this.metricKey), compositeTicker);
                }
                catch (RuntimeException e) {
                    log.warn("Failed to start metric trace for {}", (Object)this.metricKey, (Object)e);
                }
            }
            return compositeTicker == null ? Ticker.NO_OP : compositeTicker;
        }

        @Override
        public void update(Duration time) {
            if (Metrics.getConfiguration().isEnabled()) {
                Objects.requireNonNull(time, "time");
                for (MetricStrategy strategy : StrategiesRegistry.getMetricStrategies()) {
                    try {
                        strategy.updateTimer(this.metricKey, time);
                    }
                    catch (RuntimeException e) {
                        log.warn("Failed to update metric for {}", (Object)this.metricKey, (Object)e);
                    }
                }
            }
        }
    }
}

