/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.v2;

import com.atlassian.renderer.Icon;
import com.atlassian.renderer.IconManager;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.RendererConfiguration;
import com.atlassian.renderer.links.Link;
import com.atlassian.renderer.links.LinkRenderer;
import com.atlassian.renderer.links.UnpermittedLink;
import com.atlassian.renderer.links.UnresolvedLink;
import com.atlassian.renderer.links.UrlLink;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.SubRenderer;
import com.atlassian.renderer.v2.components.HtmlEscaper;
import com.atlassian.renderer.wysiwyg.WysiwygLinkHelper;
import com.opensymphony.util.TextUtils;
import org.apache.commons.lang.StringUtils;

public class V2LinkRenderer
implements LinkRenderer {
    protected SubRenderer subRenderer;
    protected IconManager iconManager;
    protected RendererConfiguration rendererConfiguration;

    public V2LinkRenderer() {
    }

    public V2LinkRenderer(SubRenderer subRenderer, IconManager iconManager, RendererConfiguration rendererConfiguration) {
        this.subRenderer = subRenderer;
        this.iconManager = iconManager;
        this.rendererConfiguration = rendererConfiguration;
    }

    @Override
    public String renderLink(Link link, RenderContext renderContext) {
        StringBuffer buffer = new StringBuffer();
        if ((link instanceof UnresolvedLink || link instanceof UnpermittedLink) && !renderContext.isRenderingForWysiwyg()) {
            buffer.append("<strike>").append(link.getLinkBody()).append("</strike>");
            return buffer.toString();
        }
        Icon icon = this.iconManager.getLinkDecoration(link.getIconName());
        if (icon.position != 0) {
            buffer.append("<span class=\"nobr\">");
        }
        buffer.append("<a href=\"");
        if (link.isRelativeUrl() && renderContext.getSiteRoot() != null) {
            buffer.append(renderContext.getSiteRoot());
        }
        buffer.append(V2LinkRenderer.unescapeEscapeSequences(HtmlEscaper.escapeAmpersands(link.getUrl(), true)));
        buffer.append("\"");
        if (renderContext.isRenderingForWysiwyg()) {
            buffer.append("\n");
        }
        if (StringUtils.isNotEmpty((String)link.getTitle())) {
            buffer.append(" title=\"").append(TextUtils.htmlEncode((String)this.getLinkTitle(link))).append("\"");
        }
        buffer.append(link.getLinkAttributes());
        if (link instanceof UrlLink && this.rendererConfiguration.isNofollowExternalLinks()) {
            buffer.append(" rel=\"nofollow\"");
        }
        if (renderContext.isRenderingForWysiwyg()) {
            buffer.append(WysiwygLinkHelper.getLinkInfoAttributes(link));
        }
        buffer.append(">");
        if (icon.position == -1) {
            buffer.append(icon.toHtml(renderContext.getImagePath()));
        }
        if (link.getLinkBody().equals(link.getUrl()) || link.getLinkBody().equals(link.getOriginalLinkText())) {
            buffer.append(this.subRenderer.render(link.getLinkBody(), renderContext, RenderMode.allow(4224L)));
        } else {
            buffer.append(this.subRenderer.render(link.getLinkBody(), renderContext, RenderMode.PHRASES_IMAGES));
        }
        if (icon.position == 1) {
            buffer.append(icon.toHtml(renderContext.getImagePath()));
        }
        buffer.append("</a>");
        if (icon.position != 0) {
            buffer.append("</span>");
        }
        return buffer.toString();
    }

    protected String getLinkTitle(Link link) {
        return link.getTitle();
    }

    private static String unescapeEscapeSequences(String s) {
        if (s == null) {
            return "";
        }
        StringBuffer result = new StringBuffer(s.length());
        char[] chars = s.toCharArray();
        int prev = 0;
        for (int n : chars) {
            if (n != 92 || prev == 92) {
                result.append((char)n);
            }
            prev = n;
        }
        return result.toString();
    }

    public void setSubRenderer(SubRenderer subRenderer) {
        this.subRenderer = subRenderer;
    }

    public void setIconManager(IconManager iconManager) {
        this.iconManager = iconManager;
    }

    public void setRendererConfiguration(RendererConfiguration rendererConfiguration) {
        this.rendererConfiguration = rendererConfiguration;
    }
}

