/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.scheduler.core.util;

import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;

public class JobRunnerRegistry {
    private final ConcurrentMap<JobRunnerKey, JobRunner> jobRunnerRegistry = new ConcurrentHashMap<JobRunnerKey, JobRunner>();

    public void registerJobRunner(JobRunnerKey jobRunnerKey, JobRunner jobRunner) {
        this.jobRunnerRegistry.put((JobRunnerKey)Assertions.notNull((String)"jobRunnerKey", (Object)jobRunnerKey), (JobRunner)Assertions.notNull((String)"jobRunner", (Object)jobRunner));
    }

    public void unregisterJobRunner(JobRunnerKey jobRunnerKey) {
        this.jobRunnerRegistry.remove(Assertions.notNull((String)"jobRunnerKey", (Object)jobRunnerKey));
    }

    public JobRunner getJobRunner(JobRunnerKey jobRunnerKey) {
        return (JobRunner)this.jobRunnerRegistry.get(Assertions.notNull((String)"jobRunnerKey", (Object)jobRunnerKey));
    }

    @Nonnull
    public Set<JobRunnerKey> getRegisteredJobRunnerKeys() {
        return ImmutableSet.copyOf(this.jobRunnerRegistry.keySet());
    }
}

