/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.scheduler.quartz2;

import com.atlassian.scheduler.SchedulerRuntimeException;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.core.AbstractSchedulerService;
import com.atlassian.scheduler.core.spi.RunDetailsDao;
import com.atlassian.scheduler.core.spi.SchedulerServiceConfiguration;
import com.atlassian.scheduler.quartz2.Quartz2JobDetailsFactory;
import com.atlassian.scheduler.quartz2.Quartz2SchedulerFacade;
import com.atlassian.scheduler.quartz2.Quartz2TriggerFactory;
import com.atlassian.scheduler.quartz2.spi.Quartz2SchedulerConfiguration;
import com.atlassian.scheduler.status.JobDetails;
import com.atlassian.tenancy.api.TenantAccessor;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Quartz2SchedulerService
extends AbstractSchedulerService {
    private static final Logger LOG = LoggerFactory.getLogger(Quartz2SchedulerService.class);
    private final Quartz2SchedulerFacade localJobs;
    private final Quartz2SchedulerFacade clusteredJobs;
    private final Quartz2TriggerFactory triggerFactory;
    private final Quartz2JobDetailsFactory jobDetailsFactory;

    public Quartz2SchedulerService(RunDetailsDao runDetailsDao, Quartz2SchedulerConfiguration config, TenantAccessor tenantAccessor) throws SchedulerServiceException {
        super(runDetailsDao, tenantAccessor);
        this.localJobs = Quartz2SchedulerFacade.createLocal((AbstractSchedulerService)this, config);
        this.clusteredJobs = Quartz2SchedulerFacade.createClustered((AbstractSchedulerService)this, config);
        this.triggerFactory = new Quartz2TriggerFactory(config, this.getParameterMapSerializer());
        this.jobDetailsFactory = new Quartz2JobDetailsFactory(this);
    }

    public Quartz2SchedulerService(RunDetailsDao runDetailsDao, SchedulerServiceConfiguration config, Scheduler localScheduler, Scheduler clusteredScheduler, TenantAccessor tenantAccessor) throws SchedulerServiceException {
        super(runDetailsDao, tenantAccessor);
        this.localJobs = Quartz2SchedulerFacade.createLocal((AbstractSchedulerService)this, localScheduler);
        this.clusteredJobs = Quartz2SchedulerFacade.createClustered((AbstractSchedulerService)this, clusteredScheduler);
        this.triggerFactory = new Quartz2TriggerFactory(config, this.getParameterMapSerializer());
        this.jobDetailsFactory = new Quartz2JobDetailsFactory(this);
    }

    protected void doScheduleJob(JobId jobId, JobConfig jobConfig) throws SchedulerServiceException {
        try {
            Assertions.notNull((String)"jobConfig", (Object)jobConfig);
            LOG.debug("scheduleJob: {}: {}", (Object)jobId, (Object)jobConfig);
            this.localJobs.unscheduleJob(jobId);
            this.clusteredJobs.unscheduleJob(jobId);
            Quartz2SchedulerFacade facade = this.getFacade(jobConfig.getRunMode());
            JobRunnerKey jobRunnerKey = jobConfig.getJobRunnerKey();
            TriggerBuilder<?> trigger = this.triggerFactory.buildTrigger(jobId, jobConfig);
            facade.scheduleJob(jobRunnerKey, trigger);
        }
        catch (SchedulerRuntimeException sre) {
            throw Quartz2SchedulerService.checked((SchedulerRuntimeException)sre);
        }
    }

    public void unscheduleJob(JobId jobId) {
        boolean found = this.localJobs.unscheduleJob(jobId);
        if (found |= this.clusteredJobs.unscheduleJob(jobId)) {
            LOG.debug("unscheduleJob: {}", (Object)jobId);
        } else {
            LOG.debug("unscheduleJob for non-existent jobId: {}", (Object)jobId);
        }
    }

    @Nullable
    public Date calculateNextRunTime(Schedule schedule) throws SchedulerServiceException {
        Trigger trigger = this.triggerFactory.buildTrigger(schedule).withIdentity(TriggerKey.triggerKey((String)"name", (String)"group")).build();
        return trigger.getFireTimeAfter(new Date());
    }

    @Nullable
    public JobDetails getJobDetails(JobId jobId) {
        JobDetails jobDetails = this.getJobDetails(this.clusteredJobs, jobId, RunMode.RUN_ONCE_PER_CLUSTER);
        if (jobDetails == null) {
            jobDetails = this.getJobDetails(this.localJobs, jobId, RunMode.RUN_LOCALLY);
        }
        return jobDetails;
    }

    @Nonnull
    public Set<JobRunnerKey> getJobRunnerKeysForAllScheduledJobs() {
        HashSet<JobRunnerKey> jobRunnerKeys = new HashSet<JobRunnerKey>(this.localJobs.getJobRunnerKeys());
        jobRunnerKeys.addAll(this.clusteredJobs.getJobRunnerKeys());
        return ImmutableSet.copyOf(jobRunnerKeys);
    }

    @Nullable
    private JobDetails getJobDetails(Quartz2SchedulerFacade facade, JobId jobId, RunMode runMode) {
        Trigger trigger = facade.getTrigger(jobId);
        return trigger != null ? this.jobDetailsFactory.buildJobDetails(jobId, trigger, runMode) : null;
    }

    @Nonnull
    public List<JobDetails> getJobsByJobRunnerKey(JobRunnerKey jobRunnerKey) {
        UniqueJobDetailsCollector collector = new UniqueJobDetailsCollector();
        collector.collect(RunMode.RUN_ONCE_PER_CLUSTER, this.clusteredJobs.getTriggersOfJob(jobRunnerKey));
        collector.collect(RunMode.RUN_LOCALLY, this.localJobs.getTriggersOfJob(jobRunnerKey));
        return collector.getResults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startImpl() throws SchedulerServiceException {
        boolean abort = true;
        this.localJobs.start();
        try {
            this.clusteredJobs.start();
            abort = false;
        }
        finally {
            if (abort) {
                this.localJobs.standby();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void standbyImpl() throws SchedulerServiceException {
        try {
            this.localJobs.standby();
        }
        finally {
            this.clusteredJobs.standby();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdownImpl() {
        try {
            this.localJobs.shutdown();
        }
        finally {
            this.clusteredJobs.shutdown();
        }
    }

    private Quartz2SchedulerFacade getFacade(RunMode runMode) {
        switch ((RunMode)Assertions.notNull((String)"runMode", (Object)runMode)) {
            case RUN_LOCALLY: {
                return this.localJobs;
            }
            case RUN_ONCE_PER_CLUSTER: {
                return this.clusteredJobs;
            }
        }
        throw new IllegalArgumentException("runMode=" + runMode);
    }

    static class SortByJobId
    implements Comparator<JobDetails>,
    Serializable {
        private static final long serialVersionUID = 1L;

        SortByJobId() {
        }

        @Override
        public int compare(JobDetails jd1, JobDetails jd2) {
            return jd1.getJobId().compareTo(jd2.getJobId());
        }
    }

    class UniqueJobDetailsCollector {
        final Set<String> jobIdsSeen = Sets.newHashSet();
        final List<JobDetails> jobs = Lists.newArrayList();

        UniqueJobDetailsCollector() {
        }

        void collect(RunMode runMode, List<? extends Trigger> triggers) {
            for (Trigger trigger : triggers) {
                String jobId = trigger.getKey().getName();
                if (!this.jobIdsSeen.add(jobId)) continue;
                try {
                    this.jobs.add(Quartz2SchedulerService.this.jobDetailsFactory.buildJobDetails(JobId.of((String)jobId), trigger, runMode));
                }
                catch (SchedulerRuntimeException sre) {
                    LOG.debug("Unable to reconstruct log details for jobId '{}': {}", (Object)jobId, (Object)sre);
                }
            }
        }

        List<JobDetails> getResults() {
            Collections.sort(this.jobs, new SortByJobId());
            return ImmutableList.copyOf(this.jobs);
        }
    }
}

