/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.seraph.config;

import com.atlassian.seraph.config.RedirectPolicy;
import com.atlassian.seraph.config.SecurityConfig;
import com.atlassian.seraph.util.RedirectUtils;
import java.net.IDN;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class DefaultRedirectPolicy
implements RedirectPolicy {
    private static final Pattern MORE_THAN_2_LEADING_SLASHES = Pattern.compile("^///+");
    private static final Pattern PROTOCOL_PATTERN = Pattern.compile("^.*:");
    private static final Pattern PROTOCOL_PATTERN_WITH_SLASHES = Pattern.compile("^.*://");
    private boolean allowAnyUrl = false;

    @Override
    public void init(Map<String, String> params, SecurityConfig config) {
        if (params == null) {
            throw new IllegalArgumentException("params is not allowed to be null");
        }
        this.allowAnyUrl = "true".equals(params.get("allow.any.redirect.url"));
    }

    public boolean isAllowAnyUrl() {
        return this.allowAnyUrl;
    }

    @Override
    public boolean allowedRedirectDestination(String redirectUrl, HttpServletRequest request) {
        URI uri;
        if (this.allowAnyUrl) {
            return true;
        }
        String foldedSlashes = this.foldLeadingSlashes(redirectUrl, request.getScheme());
        try {
            String str = this.prepareHostStringIfPossible(foldedSlashes);
            uri = new URI(str);
        }
        catch (IllegalArgumentException | URISyntaxException e) {
            return false;
        }
        return uri.getHost() == null || RedirectUtils.sameContext(foldedSlashes, request);
    }

    private String prepareHostStringIfPossible(String redirectUrl) {
        String scheme = this.getScheme(redirectUrl);
        if (StringUtils.isNotBlank((CharSequence)scheme)) {
            return this.decodeHostPart(redirectUrl, scheme + "://");
        }
        return redirectUrl;
    }

    private String decodeHostPart(String redirectUrl, String scheme) {
        String substring = redirectUrl.substring(scheme.length());
        if ((substring = substring.replaceAll("^/*", "")).contains("/")) {
            substring = substring.substring(0, substring.indexOf("/"));
        }
        if (substring.contains(":")) {
            int portIndex = substring.indexOf(":");
            String hostOnly = substring.substring(0, portIndex);
            return scheme + IDN.toASCII(hostOnly) + substring.substring(portIndex);
        }
        return scheme + IDN.toASCII(substring);
    }

    private String foldLeadingSlashes(String url, String scheme) {
        Matcher protocolMatcher = PROTOCOL_PATTERN.matcher(url);
        if (protocolMatcher.find()) {
            return protocolMatcher.group() + this.tryRemoveExcessSlashes(url.substring(protocolMatcher.end()), "");
        }
        return this.tryRemoveExcessSlashes(url, scheme);
    }

    private String tryRemoveExcessSlashes(String url, String scheme) {
        Matcher leadingSlashesMatcher = MORE_THAN_2_LEADING_SLASHES.matcher(url);
        if (leadingSlashesMatcher.find()) {
            String part = leadingSlashesMatcher.replaceFirst("//");
            return this.appendSchemeIfRequired(scheme, part);
        }
        return this.appendSchemeIfRequired(scheme, url);
    }

    private String appendSchemeIfRequired(String scheme, String part) {
        if (scheme.length() == 0 || StringUtils.isNotBlank((CharSequence)this.getScheme(part))) {
            return part;
        }
        if (part.startsWith(":")) {
            return scheme + part;
        }
        if (part.startsWith("//")) {
            return scheme + ":" + part;
        }
        return part;
    }

    private String getScheme(String url) {
        Matcher protocolMatcher = PROTOCOL_PATTERN_WITH_SLASHES.matcher(url);
        if (protocolMatcher.find()) {
            String protocolWithSlashes = protocolMatcher.group();
            return protocolWithSlashes.substring(0, protocolWithSlashes.length() - 3);
        }
        return null;
    }
}

