/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.internal;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.EntityLinkService;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.streams.api.builder.StreamsFeedUriBuilderFactory;
import com.atlassian.streams.internal.ActivityProvider;
import com.atlassian.streams.internal.AppLinksActivityProvider;
import com.atlassian.streams.internal.applinks.ApplicationLinkServiceExtensions;
import com.atlassian.streams.internal.feed.FeedParser;
import com.atlassian.streams.spi.EntityResolver;
import com.atlassian.streams.spi.StreamsI18nResolver;
import com.atlassian.streams.spi.StreamsLocaleProvider;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.util.Set;

public class AppLinksActivityProviders
implements Supplier<Iterable<ActivityProvider>> {
    private final ApplicationLinkService appLinkService;
    private final EntityLinkService entityLinkService;
    private final Iterable<EntityResolver> entityResolvers;
    private final FeedParser feedParser;
    private final StreamsFeedUriBuilderFactory streamsFeedUriBuilderFactory;
    private final StreamsLocaleProvider streamsLocaleProvider;
    private final TransactionTemplate transactionTemplate;
    private final ApplicationLinkServiceExtensions appLinkServiceExtensions;
    private final StreamsI18nResolver i18nResolver;

    AppLinksActivityProviders(ApplicationLinkService appLinkService, EntityLinkService entityLinkService, Set<EntityResolver> entityResolvers, FeedParser feedParser, StreamsFeedUriBuilderFactory streamsFeedUriBuilderFactory, StreamsLocaleProvider streamsLocaleProvider, TransactionTemplate transactionTemplate, ApplicationLinkServiceExtensions appLinkServiceExtensions, StreamsI18nResolver i18nResolver) {
        this.appLinkService = (ApplicationLinkService)Preconditions.checkNotNull((Object)appLinkService, (Object)"appLinkService");
        this.entityLinkService = (EntityLinkService)Preconditions.checkNotNull((Object)entityLinkService, (Object)"entityLinkService");
        this.entityResolvers = (Iterable)Preconditions.checkNotNull(entityResolvers, (Object)"entityResolvers");
        this.feedParser = (FeedParser)Preconditions.checkNotNull((Object)feedParser, (Object)"feedParser");
        this.streamsFeedUriBuilderFactory = (StreamsFeedUriBuilderFactory)Preconditions.checkNotNull((Object)streamsFeedUriBuilderFactory, (Object)"streamsFeedUriBuilderFactory");
        this.streamsLocaleProvider = (StreamsLocaleProvider)Preconditions.checkNotNull((Object)streamsLocaleProvider, (Object)"streamsLocaleProvider");
        this.transactionTemplate = (TransactionTemplate)Preconditions.checkNotNull((Object)transactionTemplate, (Object)"transactionTemplate");
        this.appLinkServiceExtensions = (ApplicationLinkServiceExtensions)Preconditions.checkNotNull((Object)appLinkServiceExtensions, (Object)"appLinkServiceExtensions");
        this.i18nResolver = (StreamsI18nResolver)Preconditions.checkNotNull((Object)i18nResolver, (Object)"i18nResolver");
    }

    public Iterable<ActivityProvider> get() {
        return Iterables.transform((Iterable)Iterables.filter((Iterable)this.appLinkService.getApplicationLinks(), AppLinksActivityProviders.removeOptOuts()), this.toAppLinkProvider());
    }

    static Predicate<? super ApplicationLink> removeOptOuts() {
        return new Predicate<ApplicationLink>(){

            public boolean apply(ApplicationLink link) {
                String value = (String)link.getProperty("IS_ACTIVITY_ITEM_PROVIDER");
                return value == null || Boolean.parseBoolean(value);
            }
        };
    }

    private Function<ApplicationLink, ActivityProvider> toAppLinkProvider() {
        return new Function<ApplicationLink, ActivityProvider>(){

            public ActivityProvider apply(ApplicationLink appLink) {
                return new AppLinksActivityProvider(appLink, AppLinksActivityProviders.this.entityLinkService, AppLinksActivityProviders.this.entityResolvers, AppLinksActivityProviders.this.feedParser, AppLinksActivityProviders.this.streamsFeedUriBuilderFactory, AppLinksActivityProviders.this.streamsLocaleProvider, AppLinksActivityProviders.this.transactionTemplate, AppLinksActivityProviders.this.appLinkServiceExtensions, AppLinksActivityProviders.this.i18nResolver);
            }
        };
    }
}

