/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.internal;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.streams.api.ActivityRequest;
import com.atlassian.streams.api.StreamsException;
import com.atlassian.streams.api.StreamsFeed;
import com.atlassian.streams.api.common.Either;
import com.atlassian.streams.internal.ActivityProvider;
import com.atlassian.streams.internal.ActivityRequestImpl;
import com.atlassian.streams.internal.feed.FeedModel;
import com.atlassian.streams.internal.feed.builder.FeedFetcher;
import com.atlassian.streams.internal.rest.representations.ProviderFilterRepresentation;
import com.atlassian.streams.internal.rest.representations.StreamsKeysRepresentation;
import com.atlassian.streams.spi.ActivityProviderModuleDescriptor;
import com.atlassian.streams.spi.CancellableTask;
import com.atlassian.streams.spi.SessionManager;
import com.atlassian.streams.spi.StreamsActivityProvider;
import com.atlassian.streams.spi.StreamsCommentHandler;
import com.atlassian.streams.spi.StreamsFilterOptionProvider;
import com.atlassian.streams.spi.StreamsI18nResolver;
import com.atlassian.streams.spi.StreamsKeyProvider;
import com.atlassian.streams.spi.StreamsValidator;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Collections;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LocalActivityProvider
implements ActivityProvider {
    public static final String ACCEPT_LANGUAGE_KEY = "Accept-Language";
    private static final Logger logger = LoggerFactory.getLogger(LocalActivityProvider.class);
    private final String key;
    private final String name;
    private final StreamsActivityProvider activityProvider;
    private final StreamsFilterOptionProvider filterOptionProvider;
    private final StreamsKeyProvider keyProvider;
    private final StreamsValidator validator;
    private final StreamsCommentHandler commentHandler;
    private final TransactionTemplate transactionTemplate;
    private final StreamsI18nResolver i18nResolver;
    private final SessionManager sessionManager;
    private final ApplicationProperties applicationProperties;
    private final Predicate<String> areValid = new Predicate<String>(){

        public boolean apply(String key) {
            return LocalActivityProvider.this.validator.isValidKey(key);
        }
    };

    public LocalActivityProvider(ActivityProviderModuleDescriptor descriptor, SessionManager sessionManager, TransactionTemplate transactionTemplate, StreamsI18nResolver i18nResolver, ApplicationProperties applicationProperties) {
        this.key = Objects.requireNonNull(descriptor.getKey(), "key");
        this.name = Objects.requireNonNull(descriptor.getI18nNameKey() != null ? i18nResolver.getText(descriptor.getI18nNameKey()) : descriptor.getName(), "name");
        this.activityProvider = Objects.requireNonNull(descriptor.getModule(), "activityProvider");
        this.sessionManager = Objects.requireNonNull(sessionManager, "sessionManager");
        this.transactionTemplate = Objects.requireNonNull(transactionTemplate, "transactionTemplate");
        this.i18nResolver = Objects.requireNonNull(i18nResolver, "i18nResolver");
        this.applicationProperties = Objects.requireNonNull(applicationProperties, "applicationProperties");
        this.filterOptionProvider = descriptor.getFilterOptionProvider();
        this.keyProvider = descriptor.getKeyProvider();
        this.validator = descriptor.getValidator();
        this.commentHandler = descriptor.getCommentHandler();
    }

    @Override
    public boolean matches(String key) {
        return this.getKey().equals(key);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getBaseUrl() {
        return this.applicationProperties.getBaseUrl();
    }

    @Override
    public String getType() {
        return this.applicationProperties.getDisplayName();
    }

    @Override
    public CancellableTask<Either<ActivityProvider.Error, FeedModel>> getActivityFeed(final ActivityRequestImpl request) throws StreamsException {
        final CancellableTask task = this.activityProvider.getActivityFeed((ActivityRequest)request);
        return new CancellableTask<Either<ActivityProvider.Error, FeedModel>>(){

            public Either<ActivityProvider.Error, FeedModel> call() throws Exception {
                return (Either)LocalActivityProvider.this.sessionManager.withSession((Supplier)new Supplier<Either<ActivityProvider.Error, FeedModel>>(){

                    public Either<ActivityProvider.Error, FeedModel> get() {
                        return (Either)LocalActivityProvider.this.transactionTemplate.execute((TransactionCallback)LocalActivityProvider.this.fetchFeed(request, (CancellableTask<StreamsFeed>)task));
                    }
                });
            }

            public CancellableTask.Result cancel() {
                return task.cancel();
            }
        };
    }

    @Override
    public Either<ActivityProvider.Error, Iterable<ProviderFilterRepresentation>> getFilters(boolean addApplinkName) {
        if (this.filterOptionProvider == null) {
            return Either.right(Collections.emptyList());
        }
        return Either.right((Object)ImmutableList.of((Object)new ProviderFilterRepresentation(this.key, this.name, "", this.filterOptionProvider, (I18nResolver)this.i18nResolver)));
    }

    @Override
    public StreamsKeysRepresentation getKeys() {
        if (this.keyProvider == null) {
            return new StreamsKeysRepresentation((Iterable<StreamsKeyProvider.StreamsKey>)ImmutableList.of());
        }
        return new StreamsKeysRepresentation(this.keyProvider.getKeys());
    }

    @Override
    public boolean allKeysAreValid(Iterable<String> keys) {
        if (this.validator == null) {
            return false;
        }
        return Iterables.all(keys, this.areValid);
    }

    public Either<StreamsCommentHandler.PostReplyError, URI> postReply(URI baseUri, Iterable<String> itemPath, String comment) {
        return this.commentHandler.postReply(baseUri, itemPath, comment);
    }

    private FeedFetcher fetchFeed(ActivityRequest request, CancellableTask<StreamsFeed> task) {
        return new FeedFetcher(this.i18nResolver, request, task, this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalActivityProvider that = (LocalActivityProvider)o;
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }
}

