/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.ta.wiremockpactgenerator;

import com.atlassian.ta.wiremockpactgenerator.WireMockPactGeneratorUserOptions;
import com.atlassian.ta.wiremockpactgenerator.pactgenerator.PactGeneratorRegistry;
import com.atlassian.ta.wiremockpactgenerator.pactgenerator.PactGeneratorRequest;
import com.atlassian.ta.wiremockpactgenerator.pactgenerator.PactGeneratorResponse;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestListener;
import com.github.tomakehurst.wiremock.http.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class WireMockPactGenerator
implements RequestListener {
    private final WireMockPactGeneratorUserOptions userOptions;
    private final Consumer<RuntimeException> unexpectedErrorHandler;

    public static Builder builder(String consumerName, String providerName) {
        return new Builder(consumerName, providerName);
    }

    private WireMockPactGenerator(WireMockPactGeneratorUserOptions userOptions, Consumer<RuntimeException> unexpectedErrorHandler) {
        this.userOptions = userOptions;
        this.unexpectedErrorHandler = unexpectedErrorHandler;
    }

    public void requestReceived(Request request, Response response) {
        try {
            this.processInteraction(request, response);
        }
        catch (RuntimeException exception) {
            this.unexpectedErrorHandler.accept(exception);
        }
    }

    public String getPactLocation() {
        return PactGeneratorRegistry.getPactLocation(this.userOptions);
    }

    private void processInteraction(Request request, Response response) {
        PactGeneratorRequest.Builder requestBuilder = new PactGeneratorRequest.Builder().withMethod(request.getMethod().value()).withUrl(request.getUrl()).withHeaders(this.extractHeaders(request.getHeaders())).withBody(request.getBodyAsString());
        PactGeneratorResponse.Builder responseBuilder = new PactGeneratorResponse.Builder().withStatus(response.getStatus()).withHeaders(this.extractHeaders(response.getHeaders())).withBody(response.getBody() == null ? "" : response.getBodyAsString()).withIsConfiguredResponse(response.wasConfigured());
        PactGeneratorRegistry.processInteraction(this.userOptions, requestBuilder.build(), responseBuilder.build());
    }

    private Map<String, List<String>> extractHeaders(HttpHeaders wireMockHeaders) {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        for (HttpHeader header : wireMockHeaders.all()) {
            headers.put(header.key(), header.values());
        }
        return headers;
    }

    public static class Builder {
        private static final Consumer<RuntimeException> defaultUnexpectedErrorHandler = e -> {
            System.err.println("WireMock Pact Generator: unexpected error. Forcing system exit.");
            e.printStackTrace();
            System.exit(1);
        };
        private final List<String> requestPathWhitelist;
        private final List<String> requestPathBlacklist;
        private final String consumerName;
        private final String providerName;
        private final boolean strictApplicationJson;
        private final List<String> requestHeaderWhitelist;
        private final List<String> responseHeaderWhitelist;
        private final Consumer<RuntimeException> unexpectedErrorHandler;

        private Builder(String consumerName, String providerName) {
            this(consumerName, providerName, Collections.emptyList(), Collections.emptyList(), true, Collections.emptyList(), Collections.emptyList(), defaultUnexpectedErrorHandler);
        }

        private Builder(String consumerName, String providerName, List<String> requestPathWhitelist, List<String> requestPathBlacklist, boolean strictApplicationJson, List<String> requestHeaderWhitelist, List<String> responseHeaderWhitelist, Consumer<RuntimeException> unexpectedErrorHandler) {
            this.consumerName = consumerName;
            this.providerName = providerName;
            this.requestPathWhitelist = requestPathWhitelist;
            this.requestPathBlacklist = requestPathBlacklist;
            this.strictApplicationJson = strictApplicationJson;
            this.requestHeaderWhitelist = requestHeaderWhitelist;
            this.responseHeaderWhitelist = responseHeaderWhitelist;
            this.unexpectedErrorHandler = unexpectedErrorHandler;
        }

        public Builder withRequestPathWhitelist(String ... regexPatterns) {
            List<String> newRequestPathWhitelist = this.extendListWithItems(this.requestPathWhitelist, regexPatterns);
            return new Builder(this.consumerName, this.providerName, newRequestPathWhitelist, this.requestPathBlacklist, this.strictApplicationJson, this.requestHeaderWhitelist, this.responseHeaderWhitelist, this.unexpectedErrorHandler);
        }

        public Builder withRequestPathBlacklist(String ... regexPatterns) {
            List<String> newRequestPathBlacklist = this.extendListWithItems(this.requestPathBlacklist, regexPatterns);
            return new Builder(this.consumerName, this.providerName, this.requestPathWhitelist, newRequestPathBlacklist, this.strictApplicationJson, this.requestHeaderWhitelist, this.responseHeaderWhitelist, this.unexpectedErrorHandler);
        }

        public Builder withStrictApplicationJson(boolean strictApplicationJson) {
            return new Builder(this.consumerName, this.providerName, this.requestPathWhitelist, this.requestPathBlacklist, strictApplicationJson, this.requestHeaderWhitelist, this.responseHeaderWhitelist, this.unexpectedErrorHandler);
        }

        public Builder withRequestHeaderWhitelist(String ... httpHeaders) {
            List<String> newRequestHeaderWhitelist = this.extendListWithItems(this.requestHeaderWhitelist, httpHeaders);
            return new Builder(this.consumerName, this.providerName, this.requestPathWhitelist, this.requestPathBlacklist, this.strictApplicationJson, newRequestHeaderWhitelist, this.responseHeaderWhitelist, this.unexpectedErrorHandler);
        }

        public Builder withResponseHeaderWhitelist(String ... httpHeaders) {
            List<String> newResponseHeaderWhitelist = this.extendListWithItems(this.responseHeaderWhitelist, httpHeaders);
            return new Builder(this.consumerName, this.providerName, this.requestPathWhitelist, this.requestPathBlacklist, this.strictApplicationJson, this.requestHeaderWhitelist, newResponseHeaderWhitelist, this.unexpectedErrorHandler);
        }

        public Builder withUnexpectedErrorHandler(Consumer<RuntimeException> unexpectedErrorHandler) {
            return new Builder(this.consumerName, this.providerName, this.requestPathWhitelist, this.requestPathBlacklist, this.strictApplicationJson, this.requestHeaderWhitelist, this.responseHeaderWhitelist, unexpectedErrorHandler);
        }

        public WireMockPactGenerator build() {
            WireMockPactGeneratorUserOptions userOptions = new WireMockPactGeneratorUserOptions(this.consumerName, this.providerName, this.requestPathWhitelist, this.requestPathBlacklist, this.strictApplicationJson, this.requestHeaderWhitelist, this.responseHeaderWhitelist);
            return new WireMockPactGenerator(userOptions, this.unexpectedErrorHandler);
        }

        private <T> List<T> extendListWithItems(List<T> original, T[] items) {
            ArrayList<T> copyOfOriginal = new ArrayList<T>(original);
            copyOfOriginal.addAll(Arrays.asList(items));
            return copyOfOriginal;
        }
    }
}

