/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.ta.wiremockpactgenerator.pactgenerator;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ContentFilter {
    private static final String WIREMOCK_MATCHED_STUB_ID_HEADER = "matched-stub-id";
    private static final String WIREMOCK_MATCHED_STUB_NAME_HEADER = "matched-stub-name";
    private static final List<String> IGNORE_REQUEST_HEADERS = Collections.singletonList("host");
    private static final List<String> IGNORE_RESPONSE_HEADERS = Arrays.asList("matched-stub-id", "matched-stub-name");
    private final List<String> requestHeaderWhitelist;
    private final List<String> responseHeaderWhitelist;

    public ContentFilter(List<String> requestHeaderWhitelist, List<String> responseHeaderWhitelist) {
        this.requestHeaderWhitelist = requestHeaderWhitelist;
        this.responseHeaderWhitelist = responseHeaderWhitelist;
    }

    public boolean isRequestHeaderWhitelisted(String headerName) {
        if (this.requestHeaderWhitelist.isEmpty()) {
            return !IGNORE_REQUEST_HEADERS.contains(headerName);
        }
        return ContentFilter.headerMatchesAnyCaseInsensitiveKeys(headerName, this.requestHeaderWhitelist);
    }

    public boolean isResponseHeaderWhitelisted(String headerName) {
        if (this.responseHeaderWhitelist.isEmpty()) {
            return !IGNORE_RESPONSE_HEADERS.contains(headerName);
        }
        return ContentFilter.headerMatchesAnyCaseInsensitiveKeys(headerName, this.responseHeaderWhitelist);
    }

    private static boolean headerMatchesAnyCaseInsensitiveKeys(String headerName, List<String> headerWhitelist) {
        return headerWhitelist.stream().anyMatch(key -> key.equalsIgnoreCase(headerName));
    }
}

