/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.ta.wiremockpactgenerator.pactgenerator;

import com.atlassian.ta.wiremockpactgenerator.pactgenerator.PactGeneratorRequest;
import java.util.List;
import java.util.regex.Pattern;

public class InteractionFilter {
    private final List<Pattern> requestPathWhitelist;
    private final List<Pattern> requestPathBlacklist;

    public InteractionFilter(List<Pattern> requestPathWhitelist, List<Pattern> requestPathBlacklist) {
        this.requestPathWhitelist = requestPathWhitelist;
        this.requestPathBlacklist = requestPathBlacklist;
    }

    public boolean isRequestAccepted(PactGeneratorRequest request) {
        return (this.requestPathWhitelist.isEmpty() || InteractionFilter.pathMatchesAnyPattern(request.getPath(), this.requestPathWhitelist)) && !InteractionFilter.pathMatchesAnyPattern(request.getPath(), this.requestPathBlacklist);
    }

    private static boolean pathMatchesAnyPattern(String path, List<Pattern> patternList) {
        return patternList.stream().anyMatch(pattern -> pattern.matcher(path).matches());
    }
}

