/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.ta.wiremockpactgenerator.pactgenerator;

import com.atlassian.ta.wiremockpactgenerator.pactgenerator.FileSystem;
import com.atlassian.ta.wiremockpactgenerator.pactgenerator.IdGenerator;
import com.atlassian.ta.wiremockpactgenerator.pactgenerator.InteractionFilter;
import com.atlassian.ta.wiremockpactgenerator.pactgenerator.PactGeneratorInteraction;
import com.atlassian.ta.wiremockpactgenerator.pactgenerator.PactGeneratorRequest;
import com.atlassian.ta.wiremockpactgenerator.pactgenerator.PactGeneratorResponse;
import com.atlassian.ta.wiremockpactgenerator.pactgenerator.PactGeneratorToPactInteractionTransformer;
import com.atlassian.ta.wiremockpactgenerator.pactgenerator.PactGeneratorValidation;
import com.atlassian.ta.wiremockpactgenerator.pactgenerator.PactSaver;
import com.atlassian.ta.wiremockpactgenerator.pactgenerator.models.Pact;
import com.atlassian.ta.wiremockpactgenerator.pactgenerator.models.PactInteraction;

public class PactGenerator {
    private final PactSaver pactSaver;
    private final Pact pact;

    public PactGenerator(String consumerName, String providerName, FileSystem fileSystem, IdGenerator idGenerator) {
        this.pactSaver = new PactSaver(fileSystem, idGenerator);
        this.pact = new Pact(consumerName, providerName);
    }

    public void process(PactGeneratorInteraction interaction) {
        PactGeneratorRequest request = interaction.getRequest();
        PactGeneratorResponse response = interaction.getResponse();
        InteractionFilter interactionFilter = interaction.getInteractionFilter();
        if (!interactionFilter.isRequestAccepted(request)) {
            return;
        }
        PactGeneratorValidation.validateResponse(response);
        PactInteraction pactInteraction = PactGeneratorToPactInteractionTransformer.transform(request, response, interaction.getContentFilter());
        this.pact.addInteraction(pactInteraction);
        this.pactSaver.savePactFile(this.pact, interaction.isStrictApplicationJson());
    }

    public String getPactLocation() {
        return this.pactSaver.getPactFileLocation(this.pact);
    }
}

