/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.velocity.allowlist.util;

import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.Element;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class AllowlistElements {
    private final Set<String> classes;
    private final Set<String> packages;
    private final Map<String, Set<String>> methods;

    private AllowlistElements(Set<String> classes, Set<String> packages, Map<String, Set<String>> methods) {
        this.classes = Objects.requireNonNull(classes);
        this.packages = Objects.requireNonNull(packages);
        this.methods = Objects.requireNonNull(methods);
    }

    public static AllowlistElements parse(Element rootElement) {
        Set<String> classes = rootElement.elements("class").stream().map(Element::getText).map(AllowlistElements::removeWhitespace).collect(Collectors.toUnmodifiableSet());
        Set<String> packages = rootElement.elements("package").stream().map(Element::getText).map(AllowlistElements::removeWhitespace).collect(Collectors.toUnmodifiableSet());
        Map<String, Set<String>> methods = AllowlistElements.toMap(rootElement.elements("method").stream().map(Element::getText).toList());
        return new AllowlistElements(classes, packages, methods);
    }

    private static Map<String, Set<String>> toMap(Collection<String> methodList) {
        HashMap methods = new HashMap();
        for (String methodStr : methodList) {
            String[] parts = methodStr.trim().split("#");
            if (parts.length != 2) {
                throw new PluginParseException("Invalid method format, it should be in the format \"package.Class#method(qualified.paramType1 qualified.paramType2)\", provided method was: " + methodStr);
            }
            String className = parts[0];
            String methodName = parts[1];
            methods.putIfAbsent(className, new HashSet());
            ((Set)methods.get(className)).add(methodName);
        }
        return Collections.unmodifiableMap(methods);
    }

    private static String removeWhitespace(String s) {
        return s.replaceAll("\\s", "");
    }

    public Set<String> getClasses() {
        return this.classes;
    }

    public Set<String> getPackages() {
        return this.packages;
    }

    public Map<String, Set<String>> getMethods() {
        return this.methods;
    }
}

