/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.signing.tool;

import com.atlassian.upm.signing.tool.FileUtils;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.file.Path;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.signers.Ed25519Signer;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.crypto.util.SubjectPublicKeyInfoFactory;
import org.bouncycastle.openssl.PKCS8Generator;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.bc.BcEdECContentSignerBuilder;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemReader;
import org.bouncycastle.util.io.pem.PemWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrivateKeyAndCert {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrivateKeyAndCert.class);
    private final String privateKey;
    private final String certificate;
    private static final Random RANDOM = new SecureRandom();

    public PrivateKeyAndCert(String privateKey, String certificate) {
        this.privateKey = privateKey;
        this.certificate = certificate;
    }

    public static PrivateKeyAndCert load(Path certificatePath, Path privateKeyPath) {
        boolean hasCertificate = FileUtils.isReadable(certificatePath);
        boolean hasPrivateKey = FileUtils.isReadable(privateKeyPath);
        if (!hasCertificate) {
            LOGGER.debug("Certificate file {} is absent or unreadable", (Object)certificatePath);
        }
        if (!hasPrivateKey) {
            LOGGER.debug("Private key file {} is absent or unreadable", (Object)privateKeyPath);
        }
        if (!hasCertificate && !hasPrivateKey) {
            LOGGER.warn("PrivateKeyAndCert failed to load : {} and {} are both absent or unreadable", (Object)certificatePath, (Object)privateKeyPath);
            return null;
        }
        try {
            String cert = FileUtils.readString(certificatePath);
            String pk = FileUtils.readString(privateKeyPath);
            return new PrivateKeyAndCert(pk, cert);
        }
        catch (Exception e) {
            LOGGER.warn("Exception loading PrivateKeyAndCert from {}, {} : {}", new Object[]{certificatePath, privateKeyPath, e.getMessage()});
            return null;
        }
    }

    public boolean write(Path certificatePath, Path privateKeyPath) {
        return FileUtils.write(certificatePath, this.getCertificate()) && FileUtils.write(privateKeyPath, this.getPrivateKey());
    }

    public String getCertificate() {
        return this.certificate;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public Optional<Ed25519Signer> buildSigner() {
        Optional<Ed25519Signer> optional;
        if (this.privateKey == null) {
            LOGGER.warn("Failed to create Signer : key is null");
            return Optional.empty();
        }
        StringReader reader = new StringReader(this.privateKey);
        PemReader pemReader = new PemReader((Reader)reader);
        try {
            PemObject pemObject = pemReader.readPemObject();
            byte[] privateKeyBytes = pemObject.getContent();
            Ed25519PrivateKeyParameters pKey = (Ed25519PrivateKeyParameters)PrivateKeyFactory.createKey((byte[])privateKeyBytes);
            Ed25519Signer signer = new Ed25519Signer();
            signer.init(true, (CipherParameters)pKey);
            optional = Optional.of(signer);
        }
        catch (Throwable throwable) {
            try {
                try {
                    pemReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                LOGGER.warn("Failed to create Signer", (Throwable)ioe);
                return Optional.empty();
            }
        }
        pemReader.close();
        return optional;
    }

    public static PrivateKeyAndCert generateSelfSignedX509Certificate(ZonedDateTime from, ZonedDateTime to, String issuer) {
        try {
            Ed25519PrivateKeyParameters privateKeyParams = new Ed25519PrivateKeyParameters(new SecureRandom());
            PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed25519), (ASN1Encodable)new DEROctetString(privateKeyParams.getEncoded()));
            String privateKey = PrivateKeyAndCert.writePrivateKey(privateKeyInfo);
            Ed25519PublicKeyParameters publicKeyParams = privateKeyParams.generatePublicKey();
            SubjectPublicKeyInfo publicKeyInfo = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo((AsymmetricKeyParameter)publicKeyParams);
            X500Name dnName = new X500Name("CN=" + issuer);
            X500Name subject = new X500Name("CN=" + issuer);
            BigInteger serial = BigInteger.valueOf(RANDOM.nextLong());
            X509v3CertificateBuilder certGen = new X509v3CertificateBuilder(dnName, serial, Date.from(from.toInstant()), Date.from(to.toInstant()), subject, publicKeyInfo);
            JcaX509ExtensionUtils extensionUtils = new JcaX509ExtensionUtils();
            AuthorityKeyIdentifier authorityKeyIdentifier = extensionUtils.createAuthorityKeyIdentifier(publicKeyInfo);
            certGen.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(true));
            certGen.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)new SubjectKeyIdentifier(publicKeyInfo.getEncoded()));
            certGen.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)authorityKeyIdentifier);
            certGen.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(144));
            BcEdECContentSignerBuilder signerBuilder = new BcEdECContentSignerBuilder(new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed25519));
            ContentSigner sigGen = signerBuilder.build((AsymmetricKeyParameter)privateKeyParams);
            X509CertificateHolder certificateHolder = certGen.build(sigGen);
            return new PrivateKeyAndCert(privateKey, PrivateKeyAndCert.convertX509CertToPem(new JcaX509CertificateConverter().getCertificate(certificateHolder)));
        }
        catch (Exception e) {
            throw new IllegalStateException("Error creating certificate and private key", e);
        }
    }

    private static String writePrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        StringWriter writer = new StringWriter();
        try (PemWriter privateWriter = new PemWriter((Writer)writer);){
            privateWriter.writeObject((PemObjectGenerator)new PKCS8Generator(privateKeyInfo, null).generate());
        }
        return writer.toString();
    }

    private static String convertX509CertToPem(X509Certificate certificate) throws CertificateEncodingException {
        return "-----BEGIN CERTIFICATE-----\n" + Base64.toBase64String((byte[])certificate.getEncoded()) + "\n-----END CERTIFICATE-----";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PrivateKeyAndCert)) {
            return false;
        }
        PrivateKeyAndCert that = (PrivateKeyAndCert)o;
        return Objects.equals(this.getPrivateKey(), that.getPrivateKey()) && Objects.equals(this.getCertificate(), that.getCertificate());
    }

    public int hashCode() {
        return Objects.hash(this.getPrivateKey(), this.getCertificate());
    }
}

