/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.web.servlet.plugin;

import com.atlassian.web.servlet.api.ForwardAuthorizer;
import com.atlassian.web.servlet.api.ServletForwarder;
import com.atlassian.web.servlet.plugin.ForwardAuthorizerSupplier;
import com.atlassian.web.servlet.plugin.analytics.RedirectAnalyticsEventDispatcher;
import java.net.URI;
import java.util.Optional;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@Qualifier(value="AUTHORIZING")
public class DynamicAuthorizationServletForwarder
implements ServletForwarder {
    public static final String QUALIFIER = "AUTHORIZING";
    private static final Logger LOG = LoggerFactory.getLogger(DynamicAuthorizationServletForwarder.class);
    private final ForwardAuthorizerSupplier authorizerSupplier;
    private final RedirectAnalyticsEventDispatcher eventDispatcher;

    @Autowired
    public DynamicAuthorizationServletForwarder(ForwardAuthorizerSupplier authorizerSupplier, RedirectAnalyticsEventDispatcher eventDispatcher) {
        this.authorizerSupplier = authorizerSupplier;
        this.eventDispatcher = eventDispatcher;
    }

    public void forward(HttpServletRequest request, HttpServletResponse response, URI location) {
        try {
            this.eventDispatcher.dispatchAnalyticsEvent(request, location, Optional.of(true));
            request.getRequestDispatcher(location.toString()).forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean forwardSafely(HttpServletRequest request, HttpServletResponse response, URI location) {
        Optional<Boolean> authorization = this.authorizerSupplier.getAuthorizers().stream().map(authorizer -> this.authorize(request, location, (ForwardAuthorizer)authorizer)).filter(Optional::isPresent).map(Optional::get).reduce(Boolean::logicalAnd);
        if (authorization.orElse(false).booleanValue()) {
            this.forward(request, response, location);
            return true;
        }
        this.eventDispatcher.dispatchAnalyticsEvent(request, location, authorization);
        return false;
    }

    private Optional<Boolean> authorize(HttpServletRequest request, URI location, ForwardAuthorizer authorizer) {
        try {
            return authorizer.authorizeForward(request, location);
        }
        catch (Exception e) {
            LOG.error(authorizer + " failed to authorize " + request + " targeted at " + location, (Throwable)e);
            return Optional.of(false);
        }
    }
}

