/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.web.servlet.plugin;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.web.servlet.api.ServletForwarder;
import com.atlassian.web.servlet.plugin.ServletInfoExtractor;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@ExportAsService
@Qualifier(value="RESOLVING")
@Component
public class ResolvingServletForwarder
implements ServletForwarder {
    private final ServletForwarder forwarder;
    private final ServletInfoExtractor servletInfoExtractor;

    @Autowired
    public ResolvingServletForwarder(@Qualifier(value="REMEMBERING") ServletForwarder forwarder, ServletInfoExtractor servletInfoExtractor) {
        this.forwarder = forwarder;
        this.servletInfoExtractor = servletInfoExtractor;
    }

    public void forward(HttpServletRequest request, HttpServletResponse response, URI location) {
        this.forwarder.forward(request, response, this.resolve(location, request));
    }

    private URI resolve(URI location, HttpServletRequest request) {
        URI referrer = this.servletInfoExtractor.extractFullPath(request);
        return referrer.resolve(location);
    }

    public boolean forwardSafely(HttpServletRequest request, HttpServletResponse response, URI location) {
        return this.forwarder.forwardSafely(request, response, this.resolve(location, request));
    }
}

