/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.web.servlet.plugin.analytics;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.web.servlet.plugin.ServletInfoExtractor;
import com.atlassian.web.servlet.plugin.analytics.RedirectToForwardAnalyticsEvent;
import java.net.URI;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
public class RedirectAnalyticsEventDispatcher {
    private static final Logger log = LoggerFactory.getLogger(RedirectAnalyticsEventDispatcher.class);
    private final EventPublisher eventDispatcher;
    private final ServletInfoExtractor servletInfoExtractor;

    @Autowired
    public RedirectAnalyticsEventDispatcher(@ComponentImport EventPublisher eventDispatcher, ServletInfoExtractor servletInfoExtractor) {
        this.eventDispatcher = eventDispatcher;
        this.servletInfoExtractor = servletInfoExtractor;
    }

    public void dispatchAnalyticsEvent(HttpServletRequest request, URI destination, Optional<Boolean> votingResult) {
        RedirectToForwardAnalyticsEvent.Authorization authorizationDescription = votingResult.map(boolResult -> boolResult != false ? RedirectToForwardAnalyticsEvent.Authorization.ACCEPTED : RedirectToForwardAnalyticsEvent.Authorization.REJECTED).orElse(RedirectToForwardAnalyticsEvent.Authorization.TENTATIVE);
        URI requestPath = this.servletInfoExtractor.extractFullPath(request);
        RedirectToForwardAnalyticsEvent event = new RedirectToForwardAnalyticsEvent(requestPath.toString(), destination.toString(), authorizationDescription);
        log.debug(event.toString());
        this.eventDispatcher.publish((Object)event);
    }
}

