/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.osgi.tracker;

import com.atlassian.osgi.tracker.WaitableServiceTrackerCustomizer;
import com.atlassian.util.concurrent.Promise;
import com.atlassian.util.concurrent.Promises;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.AbstractFuture;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public final class WaitableServiceTracker<K, T> {
    private final Class<T> serviceClass;
    private final Function<T, K> extractor;
    private final WaitableServiceTrackerCustomizer<T> customizer;
    private final Map<K, T> trackedServices;
    private final Set<ServiceFuture<K, T>> futures;
    private final ServiceTracker serviceTracker;

    public WaitableServiceTracker(BundleContext bundleContext, Class<T> serviceClass, Function<T, K> extractor, WaitableServiceTrackerCustomizer<T> customizer) {
        Preconditions.checkNotNull((Object)bundleContext);
        this.serviceClass = (Class)Preconditions.checkNotNull(serviceClass);
        this.extractor = (Function)Preconditions.checkNotNull(extractor);
        this.customizer = (WaitableServiceTrackerCustomizer)Preconditions.checkNotNull(customizer);
        this.trackedServices = Maps.newHashMap();
        this.futures = new CopyOnWriteArraySet<ServiceFuture<K, T>>();
        this.serviceTracker = this.newServiceTracker(bundleContext);
    }

    private ServiceTracker newServiceTracker(final BundleContext bundleContext) {
        return new ServiceTracker(bundleContext, this.serviceClass.getName(), new ServiceTrackerCustomizer(){

            public Object addingService(ServiceReference reference) {
                Object service = WaitableServiceTracker.this.serviceClass.cast(bundleContext.getService(reference));
                WaitableServiceTracker.this.addServices(ImmutableList.of(service));
                return service;
            }

            public void removedService(ServiceReference reference, Object service) {
                WaitableServiceTracker.this.removeServices(ImmutableList.of(WaitableServiceTracker.this.serviceClass.cast(service)));
            }

            public void modifiedService(ServiceReference reference, Object service) {
                this.removedService(reference, service);
                this.addingService(reference);
            }
        });
    }

    public Promise<Map<K, T>> waitFor(Predicate<Map<K, T>> predicate) {
        ServiceFuture<K, T> future = new ServiceFuture<K, T>(predicate);
        if (!future.servicesUpdated(this.trackedServices)) {
            this.futures.add(future);
        }
        return Promises.forListenableFuture(future);
    }

    WaitableServiceTracker open() {
        this.serviceTracker.open();
        return this;
    }

    void close() {
        this.serviceTracker.close();
    }

    public T get(K key) {
        return this.trackedServices.get(key);
    }

    public Set<K> getKeys() {
        return ImmutableSet.copyOf(this.trackedServices.keySet());
    }

    public Iterable<T> getAll() {
        return ImmutableList.copyOf(this.trackedServices.values());
    }

    Class getServiceClass() {
        return this.serviceClass;
    }

    void loadLocalServices(Iterable<T> localServices) {
        this.addServices(Iterables.filter(localServices, (Predicate)new Predicate<T>(){

            public boolean apply(T localService) {
                return !WaitableServiceTracker.this.trackedServices.containsValue(localService);
            }
        }));
    }

    @VisibleForTesting
    void addServices(Iterable<T> services) {
        for (T service : services) {
            this.addIfKeyNotNull(this.extractor, this.customizer, service);
        }
        this.updateFutures();
    }

    private void addIfKeyNotNull(Function<T, K> extractor, WaitableServiceTrackerCustomizer<T> customizer, T service) {
        Object key = extractor.apply(service);
        if (key != null) {
            this.trackedServices.put(key, customizer.adding(service));
        }
    }

    @VisibleForTesting
    void removeServices(Iterable<T> services) {
        this.removeFromTrackedServices(services);
        for (T service : services) {
            this.customizer.removed(service);
        }
        this.updateFutures();
    }

    private void removeFromTrackedServices(final Iterable<T> services) {
        Maps.filterValues(this.trackedServices, (Predicate)new Predicate<T>(){

            public boolean apply(T trackedService) {
                return Iterables.contains((Iterable)services, trackedService);
            }
        }).clear();
    }

    private void updateFutures() {
        for (ServiceFuture<K, T> future : this.futures) {
            if (!future.servicesUpdated(this.trackedServices)) continue;
            this.futures.remove(future);
        }
    }

    private static final class ServiceFuture<K, T>
    extends AbstractFuture<Map<K, T>> {
        private Predicate<Map<K, T>> condition;

        private ServiceFuture(Predicate<Map<K, T>> condition) {
            this.condition = (Predicate)Preconditions.checkNotNull(condition);
        }

        public boolean servicesUpdated(Map<K, T> services) {
            if (this.condition.apply(services)) {
                this.set(services);
                return true;
            }
            return false;
        }
    }
}

