/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.plugin;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.sal.api.executor.ThreadLocalDelegateExecutorFactory;
import com.atlassian.webhooks.api.publish.WebHookEvent;
import com.atlassian.webhooks.plugin.WebHookPublisher;
import com.atlassian.webhooks.plugin.module.WebHookPluginRegistrationContainer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public final class WebHookEventsProcessor
implements InitializingBean,
DisposableBean {
    private static final int QUEUE_SIZE = Integer.getInteger("webhooks.executor.queue.size", 200);
    private static final int NUM_THREADS = Integer.getInteger("webhooks.executor.thread.pool.size", 10);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ExecutorService webHookExecutor;
    private final EventPublisher eventPublisher;
    private final WebHookPublisher webHookPublisher;
    private final WebHookPluginRegistrationContainer container;
    private final PluginEventManager pluginEventManager;

    public WebHookEventsProcessor(EventPublisher eventPublisher, PluginEventManager pluginEventManager, WebHookPublisher webHookPublisher, WebHookPluginRegistrationContainer container, ThreadLocalDelegateExecutorFactory threadLocalDelegateExecutorFactory) {
        this.eventPublisher = Objects.requireNonNull(eventPublisher);
        this.pluginEventManager = Objects.requireNonNull(pluginEventManager);
        this.webHookPublisher = Objects.requireNonNull(webHookPublisher);
        this.container = Objects.requireNonNull(container);
        this.webHookExecutor = threadLocalDelegateExecutorFactory.createExecutorService((ExecutorService)new ThreadPoolExecutor(NUM_THREADS, NUM_THREADS, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(QUEUE_SIZE), new ThreadFactoryBuilder().setNameFormat("Web-Hook-Events-Processor-%d").setDaemon(true).build()));
    }

    @VisibleForTesting
    WebHookEventsProcessor(EventPublisher eventPublisher, PluginEventManager pluginEventManager, WebHookPublisher webHookPublisher, WebHookPluginRegistrationContainer container, ExecutorService executor) {
        this.eventPublisher = Objects.requireNonNull(eventPublisher);
        this.pluginEventManager = Objects.requireNonNull(pluginEventManager);
        this.webHookPublisher = Objects.requireNonNull(webHookPublisher);
        this.container = Objects.requireNonNull(container);
        this.webHookExecutor = Objects.requireNonNull(executor);
    }

    @EventListener
    public void onEvent(Object event) {
        this.doOnEvent(event);
    }

    private void doOnEvent(Object event) {
        List<WebHookEvent> events = this.getWebHooksForEvent(event);
        if (events.isEmpty()) {
            this.logger.trace("The received event is not supported by the plugin. Event: {}", (Object)event.toString());
            return;
        }
        if (this.shouldProcessEventsSynchronously(events)) {
            this.logger.debug("Some received webhook events CANNOT be processed async or this feature is disabled. Webhook events processing will be fired synchronously. Received events: ({})", (Object)events.stream().map(e -> e.getId() + (e.isProcessEventAsync() ? "" : " - NOT processable asynchronously")).collect(Collectors.joining(", ")));
            events.forEach(this.webHookPublisher::publish);
        } else {
            this.logger.debug("All received webhook events CAN be processed async. Webhook events processing will be fired asynchronously. Received events: ({})", (Object)events.stream().map(WebHookEvent::getId).collect(Collectors.joining(", ")));
            this.processWebHookEventsAsync(events);
        }
    }

    private boolean shouldProcessEventsSynchronously(List<WebHookEvent> events) {
        return events.stream().anyMatch(e -> !e.isProcessEventAsync());
    }

    private void processWebHookEventsAsync(List<WebHookEvent> events) {
        CompletableFuture[] futures = (CompletableFuture[])events.stream().map(webHookEvent -> CompletableFuture.runAsync(() -> this.webHookPublisher.publish((WebHookEvent)webHookEvent), this.webHookExecutor)).toArray(CompletableFuture[]::new);
        CompletableFuture<Void> completableFuture = CompletableFuture.allOf(futures);
        CompletableFuture.runAsync(() -> {
            try {
                completableFuture.get();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                this.logger.warn("Encountered error while sending webhooks. '{}'", (Object)ex.getMessage());
                this.logger.debug("Here is the full exception", (Throwable)ex);
            }
            catch (ExecutionException ex) {
                this.logger.warn("Encountered error while sending webhooks. '{}'", (Object)ex.getMessage());
                this.logger.debug("Here is the full exception", (Throwable)ex);
            }
        });
    }

    private List<WebHookEvent> getWebHooksForEvent(Object event) {
        return this.container.getWebHookRegistry().getWebHooks(event);
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
        this.pluginEventManager.register((Object)this);
    }

    public void destroy() throws Exception {
        this.webHookExecutor.shutdownNow();
        this.logger.warn("Webhook plugin shutdown. Some webhook events might not be published.");
        this.pluginEventManager.unregister((Object)this);
        this.eventPublisher.unregister((Object)this);
    }
}

