/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.plugin.event;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.webhooks.api.events.WebHookListenerCreatedEvent;
import com.atlassian.webhooks.api.events.WebHookListenerDeletedEvent;
import com.atlassian.webhooks.api.events.WebHookListenerEditedEvent;
import com.atlassian.webhooks.api.register.listener.PersistentWebHookListener;
import com.atlassian.webhooks.api.register.listener.RegistrationMethod;
import com.atlassian.webhooks.api.util.Filter;
import com.atlassian.webhooks.api.util.SectionKey;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;

@Named(value="webHookEventDispatcher")
public class WebHookEventDispatcher {
    private final EventPublisher eventPublisher;

    @Inject
    public WebHookEventDispatcher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void webHookCreated(PersistentWebHookListener webHook, RegistrationMethod registrationMethod) {
        this.eventPublisher.publish((Object)new WebHookListenerCreatedEvent(webHook.getName(), webHook.getUrl(), webHook.getEvents(), WebHookEventDispatcher.parametersAsMap(webHook), registrationMethod));
    }

    public void webHookDeleted(PersistentWebHookListener webHook, RegistrationMethod registrationMethod) {
        this.eventPublisher.publish((Object)new WebHookListenerDeletedEvent(webHook.getName(), webHook.getUrl(), webHook.getEvents(), WebHookEventDispatcher.parametersAsMap(webHook), registrationMethod));
    }

    public void webHookEdited(PersistentWebHookListener webHook, RegistrationMethod registrationMethod) {
        this.eventPublisher.publish((Object)new WebHookListenerEditedEvent(webHook.getName(), webHook.getUrl(), webHook.getEvents(), WebHookEventDispatcher.parametersAsMap(webHook), registrationMethod));
    }

    private static Map<String, String> parametersAsMap(PersistentWebHookListener listener) {
        HashMap result = Maps.newHashMap();
        result.put("excludeBody", String.valueOf(listener.isExcludeBody()));
        for (Map.Entry<SectionKey, Filter> entry : listener.getFilters().entrySet()) {
            result.put(entry.getKey() + "-" + "filter", entry.getValue().getValue());
        }
        return result;
    }
}

