/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.plugin.legacy;

import com.atlassian.osgi.tracker.WaitableServiceTrackerCustomizer;
import com.atlassian.osgi.tracker.WaitableServiceTrackerFactory;
import com.atlassian.webhooks.api.register.RegisteredWebHookEvent;
import com.atlassian.webhooks.api.register.WebHookPluginRegistration;
import com.atlassian.webhooks.api.register.WebHookPluginRegistrationBuilder;
import com.atlassian.webhooks.api.register.listener.WebHookListener;
import com.atlassian.webhooks.plugin.legacy.LegacyEventMatcher;
import com.atlassian.webhooks.plugin.legacy.WebHookRegistrarImpl;
import com.atlassian.webhooks.plugin.legacy.WebHookRegistration;
import com.atlassian.webhooks.plugin.module.ModuleKey;
import com.atlassian.webhooks.plugin.module.WebHookPluginRegistrationContainer;
import com.atlassian.webhooks.spi.EventMatcher;
import com.atlassian.webhooks.spi.EventSerializer;
import com.atlassian.webhooks.spi.provider.WebHookProvider;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OsgiWebHookProviderRegistry {
    @Autowired
    public OsgiWebHookProviderRegistry(WaitableServiceTrackerFactory factory, WebHookPluginRegistrationContainer registrationContainer) {
        factory.create(WebHookProvider.class, new WebHookProviderWaitableServiceTrackerCustomizer(registrationContainer));
    }

    private static class WebHookProviderWaitableServiceTrackerCustomizer
    implements WaitableServiceTrackerCustomizer<WebHookProvider> {
        private final WebHookPluginRegistrationContainer registrationContainer;

        public WebHookProviderWaitableServiceTrackerCustomizer(WebHookPluginRegistrationContainer registrationContainer) {
            this.registrationContainer = registrationContainer;
        }

        @Override
        public WebHookProvider adding(WebHookProvider provider) {
            WebHookRegistrarImpl registrar = new WebHookRegistrarImpl();
            provider.provide(registrar);
            Set<WebHookRegistration> registrations = registrar.getRegistrations();
            WebHookPluginRegistrationBuilder pluginRegistration = WebHookPluginRegistration.builder();
            for (final WebHookRegistration webhook : registrations) {
                pluginRegistration.eventSerializer(webhook.getEventClass(), new EventSerializer<Object>(){

                    @Override
                    public String serialize(Object event) {
                        return webhook.getEventSerializer(event).getWebHookBody();
                    }
                });
                pluginRegistration.addWebHook(this.toNewWebhook(webhook));
            }
            this.registrationContainer.addRegistration(ModuleKey.of(provider), pluginRegistration.build());
            return provider;
        }

        @Override
        public void removed(WebHookProvider webHookProvider) {
            this.registrationContainer.removeRegistration(ModuleKey.of(webHookProvider));
        }

        private RegisteredWebHookEvent<?> toNewWebhook(WebHookRegistration webhook) {
            return RegisteredWebHookEvent.withId(webhook.getId()).firedWhen(webhook.getEventClass()).canProcessEventAsync(false).isMatchedBy(this.createLegacyMatcher(webhook));
        }

        private EventMatcher<Object> createLegacyMatcher(final WebHookRegistration webhook) {
            return new LegacyEventMatcher<Object>(){

                @Override
                public boolean matches(Object event, WebHookListener listener) {
                    return webhook.getEventMatcher().matches(event, listener);
                }

                public boolean matches(Object event, Object listenerParameters) {
                    return webhook.getEventMatcher().matches(event, listenerParameters);
                }
            };
        }
    }
}

