/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.plugin.uri;

import com.atlassian.webhooks.api.publish.WebHookEvent;
import com.atlassian.webhooks.api.register.listener.WebHookListener;
import com.atlassian.webhooks.plugin.module.WebHookPluginRegistrationContainer;
import com.atlassian.webhooks.plugin.uri.PluggableUriResolver;
import com.atlassian.webhooks.plugin.uri.UriVariablesResolver;
import com.atlassian.webhooks.plugin.uri.UrlVariableSubstitutor;
import com.atlassian.webhooks.spi.UriVariablesProvider;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.inject.Named;
import org.osgi.framework.InvalidSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Named(value="uriVariablesResolver")
public class UriVariablesResolverImpl
implements UriVariablesResolver {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final UrlVariableSubstitutor urlVariableSubstitutor;
    private final PluggableUriResolver pluggableUriResolver;
    private final WebHookPluginRegistrationContainer registrationContainer;

    @Autowired
    public UriVariablesResolverImpl(UrlVariableSubstitutor urlVariableSubstitutor, PluggableUriResolver pluggableUriResolver, WebHookPluginRegistrationContainer registrationContainer) {
        this.urlVariableSubstitutor = urlVariableSubstitutor;
        this.pluggableUriResolver = pluggableUriResolver;
        this.registrationContainer = registrationContainer;
    }

    @Override
    public URI resolve(WebHookListener listener, WebHookEvent event) {
        try {
            String substitutedUrl = this.substitute(listener.getParameters().getUrl(), event.getEvent());
            try {
                URI uri = new URI(substitutedUrl);
                return this.pluggableUriResolver.resolve(listener.getRegistrationDetails(), uri);
            }
            catch (URISyntaxException ex) {
                this.logger.error("Could not resolve uri for event '{}' and listener '{}'", (Object)event, (Object)listener);
                throw new RuntimeException("Could not resolve uri for event " + event + " and listener " + listener, ex);
            }
            catch (InvalidSyntaxException ex) {
                this.logger.error("Could not resolve uri for event '{}' and listener '{}'", (Object)event, (Object)listener);
                throw new RuntimeException("Could not resolve uri for event " + event + " and listener " + listener, ex);
            }
        }
        catch (Error error) {
            error.printStackTrace();
            return null;
        }
    }

    private String substitute(String path, Object event) {
        Iterable<UriVariablesProvider> variableProviders = this.registrationContainer.getUriVariablesProviders().allForType(event.getClass());
        Map<String, Object> context = this.buildContext(variableProviders, event);
        return this.urlVariableSubstitutor.replace(path, context);
    }

    private Map<String, Object> buildContext(Iterable<UriVariablesProvider> webHookUriSubstitutions, Object event) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (UriVariablesProvider uriVariablesProvider : webHookUriSubstitutions) {
            builder.putAll(uriVariablesProvider.uriVariables(event));
        }
        return builder.build();
    }
}

