/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.plugin.validator;

import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.webhooks.api.register.listener.PersistentWebHookListener;
import com.atlassian.webhooks.api.util.ErrorMessage;
import com.atlassian.webhooks.api.util.MessageCollection;
import com.atlassian.webhooks.plugin.module.WebHookKey;
import com.atlassian.webhooks.plugin.module.WebHookPluginRegistrationContainer;
import com.atlassian.webhooks.plugin.module.WebHookRegistry;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.Set;
import javax.inject.Named;
import org.springframework.beans.factory.annotation.Autowired;

@Named(value="eventsValidator")
public class EventsValidator {
    private final WebHookRegistry webHookRegistry;
    private final I18nResolver i18n;

    @Autowired
    public EventsValidator(WebHookPluginRegistrationContainer container, I18nResolver i18n) {
        this.i18n = (I18nResolver)Preconditions.checkNotNull((Object)i18n);
        this.webHookRegistry = (WebHookRegistry)Preconditions.checkNotNull((Object)container.getWebHookRegistry());
    }

    public MessageCollection validate(PersistentWebHookListener registrationParameters) {
        if (registrationParameters.getEvents() != null) {
            final Set<WebHookKey> validEventNames = this.webHookRegistry.getWebHookIds();
            Iterable invalidEvents = Iterables.filter(registrationParameters.getEvents(), (Predicate)new Predicate<String>(){

                public boolean apply(String eventName) {
                    return !Iterables.contains((Iterable)validEventNames, (Object)new WebHookKey(eventName));
                }
            });
            return this.createInvalidEventsMessage(invalidEvents);
        }
        return MessageCollection.empty();
    }

    private MessageCollection createInvalidEventsMessage(Iterable<String> invalidEvents) {
        return Iterables.isEmpty(invalidEvents) ? MessageCollection.empty() : this.transformToMessageCollection(invalidEvents);
    }

    private MessageCollection transformToMessageCollection(Iterable<String> invalidEvents) {
        MessageCollection.Builder builder = MessageCollection.builder();
        for (String event : invalidEvents) {
            builder.addMessage(new ErrorMessage(this.i18n.getText("webhooks.invalid.event", new Serializable[]{event})), MessageCollection.Reason.VALIDATION_FAILED);
        }
        return builder.build();
    }
}

