/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.plugin.validator;

import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.webhooks.api.register.listener.PersistentWebHookListener;
import com.atlassian.webhooks.api.util.ErrorMessage;
import com.atlassian.webhooks.api.util.MessageCollection;
import com.atlassian.webhooks.plugin.module.CloudConditionResolver;
import com.atlassian.webhooks.plugin.uri.UrlVariableSubstitutor;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Named(value="urlValidator")
public class UrlValidator {
    private static final String URL_FIELD = "url";
    private static final List<String> ALLOWED_SCHEMES = ImmutableList.of((Object)"HTTP", (Object)"HTTPS");
    private static final Map<String, Integer> ALLOWED_CLOUD_SCHEMES = ImmutableMap.of((Object)"HTTP", (Object)80, (Object)"HTTPS", (Object)443);
    private final UrlVariableSubstitutor urlVariableSubstitutor;
    private final I18nResolver i18n;
    private final CloudConditionResolver cloudConditionResolver;

    @Autowired
    public UrlValidator(UrlVariableSubstitutor urlVariableSubstitutor, I18nResolver i18n, CloudConditionResolver cloudConditionResolver) {
        this.urlVariableSubstitutor = urlVariableSubstitutor;
        this.i18n = i18n;
        this.cloudConditionResolver = cloudConditionResolver;
    }

    public MessageCollection validate(PersistentWebHookListener registrationParameters) {
        MessageCollection.Builder builder = MessageCollection.builder();
        String registrationUrl = registrationParameters.getUrl();
        if (StringUtils.isBlank((String)registrationUrl)) {
            return builder.addMessage(new ErrorMessage(URL_FIELD, new Serializable[]{this.i18n.getText("webhooks.empty.url")}), MessageCollection.Reason.VALIDATION_FAILED).build();
        }
        String replacedUri = this.urlVariableSubstitutor.replace(registrationUrl, (Map<String, ?>)ImmutableMap.of());
        try {
            URI uri = new URI(replacedUri);
            if (!this.isProtocolValid(uri)) {
                builder.addMessage(new ErrorMessage(URL_FIELD, new Serializable[]{this.i18n.getText("webhooks.invalid.url.protocol", new Serializable[]{registrationUrl})}), MessageCollection.Reason.VALIDATION_FAILED);
            }
            if (!this.isPortValid(uri)) {
                builder.addMessage(new ErrorMessage(URL_FIELD, new Serializable[]{this.i18n.getText("webhooks.invalid.url.ondemand.ports")}), MessageCollection.Reason.VALIDATION_FAILED);
            }
        }
        catch (URISyntaxException e) {
            builder.addMessage(new ErrorMessage(URL_FIELD, new Serializable[]{this.i18n.getText("webhooks.invalid.url", new Serializable[]{registrationUrl})}), MessageCollection.Reason.VALIDATION_FAILED);
        }
        return builder.build();
    }

    private boolean isPortValid(URI uri) {
        if (this.cloudConditionResolver.isCloud()) {
            Integer portForScheme = ALLOWED_CLOUD_SCHEMES.get(((String)MoreObjects.firstNonNull((Object)uri.getScheme(), (Object)"")).toUpperCase());
            Integer port = uri.getPort();
            return port.equals(portForScheme) || port == -1;
        }
        return true;
    }

    private boolean isProtocolValid(URI uri) {
        String scheme = uri.getScheme();
        return scheme != null && ALLOWED_SCHEMES.contains(scheme.toUpperCase());
    }
}

