/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.plugin.web;

import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.sal.api.message.HelpPathResolver;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.webhooks.api.register.WebHookEventSection;
import com.atlassian.webhooks.api.register.WebHookPluginRegistration;
import com.atlassian.webhooks.plugin.module.WebHookPluginRegistrationContainerImpl;
import com.atlassian.webhooks.plugin.web.UriVariablesProviderPageContextResolver;
import com.atlassian.webhooks.plugin.web.util.HtmlSafeContent;
import com.atlassian.webhooks.plugin.web.util.RendererContextBuilder;
import com.atlassian.webhooks.spi.WebHooksHtmlPanel;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
final class AdminPageContextBuilder {
    private final WebResourceManager webResourceManager;
    private final I18nResolver i18nResolver;
    private final WebHookPluginRegistrationContainerImpl webHookPluginRegistrationContainer;
    private final UriVariablesProviderPageContextResolver uriVariablesProviderPageContextResolver;
    private final HelpPathResolver helpPathResolver;

    @Autowired
    public AdminPageContextBuilder(WebResourceManager webResourceManager, I18nResolver i18nResolver, WebHookPluginRegistrationContainerImpl webHookPluginRegistrationContainer, UriVariablesProviderPageContextResolver uriVariablesProviderPageContextResolver, HelpPathResolver helpPathResolver) {
        this.webResourceManager = webResourceManager;
        this.i18nResolver = i18nResolver;
        this.webHookPluginRegistrationContainer = webHookPluginRegistrationContainer;
        this.uriVariablesProviderPageContextResolver = uriVariablesProviderPageContextResolver;
        this.helpPathResolver = helpPathResolver;
    }

    public Map<String, Object> buildContext() throws IOException {
        this.webResourceManager.requireResourcesForContext("atl.plugins.webhooks.admin");
        RendererContextBuilder builder = new RendererContextBuilder().put("i18n", this.i18nResolver).put("helpPath", this.helpPathResolver).put("webResources", new HtmlSafeContent(){

            @Override
            public CharSequence get() {
                StringWriter writer = new StringWriter();
                AdminPageContextBuilder.this.webResourceManager.includeResources((Writer)writer, UrlMode.AUTO);
                return writer.toString();
            }
        }).put("customPanels", this.getCustomPanels()).put("webResourceManager", this.webResourceManager).put("urlVariablesMap", this.uriVariablesMapForTemplate()).put("urlVariables", this.uriVariablesProviderPageContextResolver.allUriVariables()).put("sections", this.getDisplayableSections());
        return builder.build();
    }

    private List<WebHooksHtmlPanel> getCustomPanels() {
        return ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)Iterables.transform(this.webHookPluginRegistrationContainer.getWebHookRegistrations(), (Function)new Function<WebHookPluginRegistration, List<WebHooksHtmlPanel>>(){

            public List<WebHooksHtmlPanel> apply(WebHookPluginRegistration input) {
                return input.getPanels();
            }
        })));
    }

    private Map<String, String> uriVariablesMapForTemplate() {
        final Joiner joiner = Joiner.on((String)",");
        return Maps.transformValues(this.uriVariablesProviderPageContextResolver.uriVariablesForWebhooks(), (Function)new Function<Collection<String>, String>(){

            public String apply(Collection<String> input) {
                return joiner.join(input);
            }
        });
    }

    private List<WebHookEventSection> getDisplayableSections() {
        return ImmutableList.copyOf((Iterable)Iterables.filter(this.webHookPluginRegistrationContainer.getWebHookSections(), (Predicate)new Predicate<WebHookEventSection>(){

            public boolean apply(WebHookEventSection webHookEventSection) {
                return StringUtils.isNotEmpty((String)webHookEventSection.getNameI18nKey());
            }
        }));
    }
}

