/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwt;

import com.auth0.jwt.Clock;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTDecoder;
import com.auth0.jwt.TokenUtils;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.AlgorithmMismatchException;
import com.auth0.jwt.exceptions.InvalidClaimException;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.exceptions.SignatureVerificationException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

public final class JWTVerifier {
    private final Algorithm algorithm;
    final Map<String, Object> claims;
    private final Clock clock;

    JWTVerifier(Algorithm algorithm, Map<String, Object> claims, Clock clock) {
        this.algorithm = algorithm;
        this.claims = Collections.unmodifiableMap(claims);
        this.clock = clock;
    }

    static Verification init(Algorithm algorithm) throws IllegalArgumentException {
        return new Verification(algorithm);
    }

    public DecodedJWT verify(String token) throws JWTVerificationException {
        JWT jwt = JWTDecoder.decode(token);
        this.verifyAlgorithm(jwt, this.algorithm);
        this.verifySignature(TokenUtils.splitToken(token));
        this.verifyClaims(jwt, this.claims);
        return jwt;
    }

    private void verifySignature(String[] parts) throws SignatureVerificationException {
        byte[] content = String.format("%s.%s", parts[0], parts[1]).getBytes(StandardCharsets.UTF_8);
        byte[] signature = Base64.decodeBase64((String)parts[2]);
        this.algorithm.verify(content, signature);
    }

    private void verifyAlgorithm(DecodedJWT jwt, Algorithm expectedAlgorithm) throws AlgorithmMismatchException {
        if (!expectedAlgorithm.getName().equals(jwt.getAlgorithm())) {
            throw new AlgorithmMismatchException("The provided Algorithm doesn't match the one defined in the JWT's Header.");
        }
    }

    private void verifyClaims(DecodedJWT jwt, Map<String, Object> claims) {
        block18: for (Map.Entry<String, Object> entry : claims.entrySet()) {
            switch (entry.getKey()) {
                case "aud": {
                    this.assertValidAudienceClaim(jwt.getAudience(), (List)entry.getValue());
                    continue block18;
                }
                case "exp": {
                    this.assertValidDateClaim(jwt.getExpiresAt(), (Long)entry.getValue(), true);
                    continue block18;
                }
                case "iat": {
                    this.assertValidDateClaim(jwt.getIssuedAt(), (Long)entry.getValue(), false);
                    continue block18;
                }
                case "nbf": {
                    this.assertValidDateClaim(jwt.getNotBefore(), (Long)entry.getValue(), false);
                    continue block18;
                }
                case "iss": {
                    this.assertValidStringClaim(entry.getKey(), jwt.getIssuer(), (String)entry.getValue());
                    continue block18;
                }
                case "jti": {
                    this.assertValidStringClaim(entry.getKey(), jwt.getId(), (String)entry.getValue());
                    continue block18;
                }
                case "sub": {
                    this.assertValidStringClaim(entry.getKey(), jwt.getSubject(), (String)entry.getValue());
                    continue block18;
                }
            }
            this.assertValidClaim(jwt.getClaim(entry.getKey()), entry.getKey(), entry.getValue());
        }
    }

    private void assertValidClaim(Claim claim, String claimName, Object value) {
        boolean isValid = false;
        if (value instanceof String) {
            isValid = value.equals(claim.asString());
        } else if (value instanceof Integer) {
            isValid = value.equals(claim.asInt());
        } else if (value instanceof Boolean) {
            isValid = value.equals(claim.asBoolean());
        } else if (value instanceof Double) {
            isValid = value.equals(claim.asDouble());
        } else if (value instanceof Date) {
            isValid = value.equals(claim.asDate());
        }
        if (!isValid) {
            throw new InvalidClaimException(String.format("The Claim '%s' value doesn't match the required one.", claimName));
        }
    }

    private void assertValidStringClaim(String claimName, String value, String expectedValue) {
        if (!expectedValue.equals(value)) {
            throw new InvalidClaimException(String.format("The Claim '%s' value doesn't match the required one.", claimName));
        }
    }

    private void assertValidDateClaim(Date date, long leeway, boolean shouldBeFuture) {
        String errMessage;
        boolean isValid;
        Date today = this.clock.getToday();
        today.setTime((long)Math.floor(today.getTime() / 1000L * 1000L));
        if (shouldBeFuture) {
            today.setTime(today.getTime() - leeway * 1000L);
            isValid = date == null || !today.after(date);
            errMessage = String.format("The Token has expired on %s.", date);
        } else {
            today.setTime(today.getTime() + leeway * 1000L);
            isValid = date == null || !today.before(date);
            errMessage = String.format("The Token can't be used before %s.", date);
        }
        if (!isValid) {
            throw new InvalidClaimException(errMessage);
        }
    }

    private void assertValidAudienceClaim(List<String> audience, List<String> value) {
        if (audience == null || !audience.containsAll(value)) {
            throw new InvalidClaimException("The Claim 'aud' value doesn't contain the required audience.");
        }
    }

    public static class Verification {
        private final Algorithm algorithm;
        private final Map<String, Object> claims;
        private long defaultLeeway;

        Verification(Algorithm algorithm) throws IllegalArgumentException {
            if (algorithm == null) {
                throw new IllegalArgumentException("The Algorithm cannot be null.");
            }
            this.algorithm = algorithm;
            this.claims = new HashMap<String, Object>();
            this.defaultLeeway = 0L;
        }

        public Verification withIssuer(String issuer) {
            this.requireClaim("iss", issuer);
            return this;
        }

        public Verification withSubject(String subject) {
            this.requireClaim("sub", subject);
            return this;
        }

        public Verification withAudience(String ... audience) {
            this.requireClaim("aud", Arrays.asList(audience));
            return this;
        }

        public Verification acceptLeeway(long leeway) throws IllegalArgumentException {
            if (leeway < 0L) {
                throw new IllegalArgumentException("Leeway value can't be negative.");
            }
            this.defaultLeeway = leeway;
            return this;
        }

        public Verification acceptExpiresAt(long leeway) throws IllegalArgumentException {
            if (leeway < 0L) {
                throw new IllegalArgumentException("Leeway value can't be negative.");
            }
            this.requireClaim("exp", leeway);
            return this;
        }

        public Verification acceptNotBefore(long leeway) throws IllegalArgumentException {
            if (leeway < 0L) {
                throw new IllegalArgumentException("Leeway value can't be negative.");
            }
            this.requireClaim("nbf", leeway);
            return this;
        }

        public Verification acceptIssuedAt(long leeway) throws IllegalArgumentException {
            if (leeway < 0L) {
                throw new IllegalArgumentException("Leeway value can't be negative.");
            }
            this.requireClaim("iat", leeway);
            return this;
        }

        public Verification withJWTId(String jwtId) {
            this.requireClaim("jti", jwtId);
            return this;
        }

        public Verification withClaim(String name, Object value) throws IllegalArgumentException {
            boolean validValue;
            boolean bl = validValue = value instanceof Integer || value instanceof Double || value instanceof Boolean || value instanceof Date || value instanceof String;
            if (name == null) {
                throw new IllegalArgumentException("The Custom Claim's name can't be null.");
            }
            if (!validValue) {
                throw new IllegalArgumentException("The Custom Claim's value class must be an instance of Integer, Double, Boolean, Date or String.");
            }
            this.requireClaim(name, value);
            return this;
        }

        public JWTVerifier build() {
            return this.build(new Clock());
        }

        JWTVerifier build(Clock clock) {
            this.addLeewayToDateClaims();
            return new JWTVerifier(this.algorithm, this.claims, clock);
        }

        private void addLeewayToDateClaims() {
            if (!this.claims.containsKey("exp")) {
                this.claims.put("exp", this.defaultLeeway);
            }
            if (!this.claims.containsKey("nbf")) {
                this.claims.put("nbf", this.defaultLeeway);
            }
            if (!this.claims.containsKey("iat")) {
                this.claims.put("iat", this.defaultLeeway);
            }
        }

        private void requireClaim(String name, Object value) {
            if (value == null) {
                this.claims.remove(name);
                return;
            }
            this.claims.put(name, value);
        }
    }
}

