/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.assurance;

import com.authlete.common.assurance.Helper;
import com.authlete.common.assurance.IDDocument;
import com.authlete.common.assurance.IdentityAssuranceException;
import com.authlete.common.assurance.QES;
import com.authlete.common.assurance.UtilityBill;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class Evidence
extends LinkedHashMap<String, Object> {
    private static final long serialVersionUID = 1L;
    private static final String TYPE = "type";

    public Evidence(String type) {
        this.put(TYPE, type);
    }

    public String getType() {
        return (String)this.get(TYPE);
    }

    public static Evidence extract(List<?> list, int index, String key) throws IdentityAssuranceException {
        Object object = Helper.extractObject(list, index, key, true);
        Map<?, ?> map = Helper.ensureMap(object, index, key);
        String parent = String.format("%s[%d]", key, index);
        String type = Helper.extractString(map, TYPE, parent, true);
        if ("id_document".equals(type)) {
            return IDDocument.extract(map);
        }
        if ("qes".equals(type)) {
            return QES.extract(map);
        }
        if ("utility_bill".equals(type)) {
            return UtilityBill.extract(map);
        }
        throw Helper.exception("'type' of '%s[%d]' is unknown.", key, index);
    }
}

