/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.assurance;

import com.authlete.common.assurance.Helper;
import com.authlete.common.assurance.IdentityAssuranceException;
import java.util.LinkedHashMap;
import java.util.Map;

public class Issuer
extends LinkedHashMap<String, Object> {
    private static final long serialVersionUID = 1L;
    private static final String NAME = "name";
    private static final String COUNTRY = "country";

    public String getName() {
        return (String)this.get(NAME);
    }

    public Issuer setName(String name) {
        this.put(NAME, name);
        return this;
    }

    public boolean containsName() {
        return this.containsKey(NAME);
    }

    public String removeName() {
        return (String)this.remove(NAME);
    }

    public String getCountry() {
        return (String)this.get(COUNTRY);
    }

    public Issuer setCountry(String country) {
        this.put(COUNTRY, country);
        return this;
    }

    public boolean containsCountry() {
        return this.containsKey(COUNTRY);
    }

    public String removeCountry() {
        return (String)this.remove(COUNTRY);
    }

    public static Issuer extract(Map<?, ?> map, String key) throws IdentityAssuranceException {
        Object object = map.get(key);
        if (object == null) {
            return null;
        }
        Issuer instance = new Issuer();
        Issuer.fill(instance, object, key);
        return instance;
    }

    private static void fill(Issuer instance, Object object, String key) {
        Map<?, ?> map = Helper.ensureMap(object, key);
        Issuer.fillName(instance, map, key);
        Issuer.fillCountry(instance, map, key);
    }

    private static void fillName(Issuer instance, Map<?, ?> map, String key) {
        String value = Helper.extractString(map, NAME, key, false);
        instance.setName(value);
    }

    private static void fillCountry(Issuer instance, Map<?, ?> map, String key) {
        String value = Helper.extractString(map, COUNTRY, key, false);
        instance.setCountry(value);
    }
}

