/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.assurance;

import com.authlete.common.assurance.Evidence;
import com.authlete.common.assurance.Helper;
import com.authlete.common.assurance.IdentityAssuranceException;
import java.util.Map;

public class QES
extends Evidence {
    private static final long serialVersionUID = 1L;
    private static final String QES = "qes";
    private static final String ISSUER = "issuer";
    private static final String SERIAL_NUMBER = "serial_number";
    private static final String CREATED_AT = "created_at";

    public QES() {
        super(QES);
    }

    public String getIssuer() {
        return (String)this.get(ISSUER);
    }

    public QES setIssuer(String issuer) {
        this.put(ISSUER, issuer);
        return this;
    }

    public boolean containsIssuer() {
        return this.containsKey(ISSUER);
    }

    public String removeIssuer() {
        return (String)this.remove(ISSUER);
    }

    public String getSerialNumber() {
        return (String)this.get(SERIAL_NUMBER);
    }

    public QES setSerialNumber(String serialNumber) {
        this.put(SERIAL_NUMBER, serialNumber);
        return this;
    }

    public boolean containsSerialNumber() {
        return this.containsKey(SERIAL_NUMBER);
    }

    public String removeSerialNumber() {
        return (String)this.remove(SERIAL_NUMBER);
    }

    public String getCreatedAt() {
        return (String)this.get(CREATED_AT);
    }

    public QES setCreatedAt(String createdAt) {
        this.put(CREATED_AT, createdAt);
        return this;
    }

    public boolean containsCreatedAt() {
        return this.containsKey(CREATED_AT);
    }

    public String removeCreatedAt() {
        return (String)this.remove(CREATED_AT);
    }

    public static QES extract(Map<?, ?> map) throws IdentityAssuranceException {
        QES instance = new QES();
        com.authlete.common.assurance.QES.fill(instance, map, QES);
        return instance;
    }

    private static void fill(QES instance, Map<?, ?> map, String key) {
        com.authlete.common.assurance.QES.fillIssuer(instance, map, key);
        com.authlete.common.assurance.QES.fillSerialNumber(instance, map, key);
        com.authlete.common.assurance.QES.fillCreatedAt(instance, map, key);
    }

    private static void fillIssuer(QES instance, Map<?, ?> map, String key) {
        String value = Helper.extractString(map, ISSUER, key, true);
        instance.setIssuer(value);
    }

    private static void fillSerialNumber(QES instance, Map<?, ?> map, String key) {
        String value = Helper.extractString(map, SERIAL_NUMBER, key, true);
        instance.setSerialNumber(value);
    }

    private static void fillCreatedAt(QES instance, Map<?, ?> map, String key) {
        String value = Helper.extractDateTime(map, CREATED_AT, key, true);
        instance.setCreatedAt(value);
    }
}

