/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.assurance.constraint;

import com.authlete.common.assurance.constraint.ConstraintException;
import com.authlete.common.assurance.constraint.Helper;
import com.authlete.common.assurance.constraint.LeafConstraint;
import java.util.Map;

public class TimeConstraint
extends LeafConstraint {
    private long maxAge;
    private boolean maxAgeExists;

    public long getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(long maxAge) {
        this.maxAge = maxAge;
    }

    public static TimeConstraint extract(Map<?, ?> map, String key) throws ConstraintException {
        TimeConstraint instance = new TimeConstraint();
        instance.setExists(map.containsKey(key));
        if (instance.exists()) {
            TimeConstraint.fill(instance, map.get(key), key);
        }
        return instance;
    }

    private static void fill(TimeConstraint instance, Object object, String key) {
        if (object == null) {
            instance.setNull(true);
            return;
        }
        Map<?, ?> map = Helper.ensureMap(object, key);
        LeafConstraint.fill(instance, map, key);
        TimeConstraint.fillMaxAge(instance, map);
    }

    private static void fillMaxAge(TimeConstraint instance, Map<?, ?> map) {
        instance.maxAgeExists = map.containsKey("max_age");
        if (instance.maxAgeExists) {
            instance.maxAge = TimeConstraint.extractLong(map, "max_age");
        }
    }

    private static long extractLong(Map<?, ?> map, String key) {
        Object value = map.get(key);
        return Helper.ensureLong(value, key);
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = super.toMap();
        if (map == null) {
            return null;
        }
        if (this.maxAgeExists) {
            map.put("max_age", this.maxAge);
        }
        return map;
    }
}

